﻿using DataAccess;
using GenClassLibrary;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace ConvertApp
{
    public partial class Report : System.Web.UI.Page
    {
        GenClass obj = new GenClass();
        SqlConnection con;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                BindReport();
            }
        }

        private void BindReport()
        {
            try
            {
                con = obj.Connect();
                SqlCommand cmd = new SqlCommand("SP_V_SelectReports", con);
                cmd.CommandType = CommandType.StoredProcedure;
                

                SqlDataAdapter sda = new SqlDataAdapter(cmd);
                DataTable dt = new DataTable();
                sda.Fill(dt);

                if (dt.Rows.Count > 0)
                {
                    DropDownListREport.DataSource = dt;
                    DropDownListREport.DataTextField = "Name";
                    DropDownListREport.DataValueField = "ID";
                    DropDownListREport.DataBind();

                }
                else
                {
                    DropDownListREport.Items.Clear();
                    DropDownListREport.Items.Insert(0, new System.Web.UI.WebControls.ListItem("-Select-", "0"));
                    
                }
            }
            catch (Exception ex)
            {

                throw ex;
            }

            finally
            {
                if (con.State == ConnectionState.Open)
                {
                    con.Close();
                }
            }
        }

        private void BindGrid()
        {
            try
            {
                con = obj.Connect();
                DataSet ds = new DataSet();
                List<SqlParameter> sqlParams = new List<SqlParameter>();

                
                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(DropDownListREport.SelectedValue, sqlParams);
                if (ds.Tables[0].Rows.Count == 0)
                {
                    GridView1.DataSource = null;
                    Buttonexcel.Visible = false;
                    LabelcntVal.Text = ds.Tables[0].Rows.Count.ToString();
                    PanelRowCount.Visible = false;

                }
                else
                {
                    GridView1.DataSource = ds;
                    Buttonexcel.Visible = true;
                    LabelcntVal.Text = ds.Tables[0].Rows.Count.ToString();
                    PanelRowCount.Visible = true;

                }
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                throw ex;
            }


        }

        protected void ButtonGo_Click(object sender, EventArgs e)
        {
            BindGrid();
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            return;
        }
        protected void Buttonexcel_Click(object sender, EventArgs e)
        {
            ExportGridToExcel();
        }


        protected void ExportGridToExcel()
        {
            string FileName = "ApprovalReport" + DateTime.Now + ".xls";
            string headerTitle = "Approval Report";
            Response.Clear();
            Response.AddHeader("content-disposition", "attachment;filename=" + FileName);
            Response.Charset = "";
            Response.ContentType = "application/vnd.xls";
            StringWriter StringWriter = new System.IO.StringWriter();
            HtmlTextWriter HtmlTextWriter = new HtmlTextWriter(StringWriter);
            StringWriter.WriteLine("<b><center><font size='4'>" + headerTitle + "</font></center></b>");

            GridView1.RenderControl(HtmlTextWriter);
            Response.Write(StringWriter.ToString());
            Response.End();
        }
    }
}