﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;
using System.IO;
namespace VMT
{
    public partial class Workarea_Company : System.Web.UI.Page
    {
       
        string m_SP_VDM_SELECT_EVTCODE_WA_COMP = Properties.Settings.Default.SP_VDM_SELECT_EVTCODE_WA_COMP;
        string m_SP_SELECT_COMPANY_FOR_WA = Properties.Settings.Default.SP_SELECT_COMPANY_FOR_WA;
        string m_SP_SELECT_WA_FOR_EVCODE = Properties.Settings.Default.SP_SELECT_WA_FOR_EVCODE;
        string m_SP_VDM_WA_COMPANY_INS_DEL = Properties.Settings.Default.SP_VDM_WA_COMPANY_INS_DEL;
        string m_SP_VDM_SELECT_BSUNIT_WA = Properties.Settings.Default.SP_VDM_SELECT_BSUNIT_WA;
        string m_SP_VDM_SELECT_YEAR_WA = Properties.Settings.Default.SP_VDM_SELECT_YEAR_WA;
        string m_SP_VDM_WA_RATES_COMPANY_ASSGN = Properties.Settings.Default.SP_VDM_WA_RATES_COMPANY_ASSGN;
        string m_SP_VDM_SELECT_WORKAREA_COMPANY = Properties.Settings.Default.SP_VDM_SELECT_WORKAREA_COMPANY;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Assign Project/Section/Work to a Vendor";

        protected void Page_Load(object sender, EventArgs e)
        {
           

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btn_expExcel);
            if (!Page.IsPostBack)
            {



                //checks user role
              

                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                { 
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }
                //   userRole = "2";
                hdn_role.Value = userRole;
                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }
                else if (userRole == "2")
                {
                    btn_add1.Visible = true;
                    btnAddRate.Visible = true;
                }
                else if (userRole == "3")
                {
                    btn_add1.Visible = true;
                    btnAddRate.Visible = true;
                }
                else if (userRole == "1")
                {
                    btn_add1.Visible = false;
                    btnAddRate.Visible = false;
                }
                btn_expExcel.Visible = false;
                bindBusinessUnit();
                bindCompany();

                if (Request.QueryString.ToString().Length > 0)
                {
                    ddl_Bunit.SelectedValue = Request.QueryString["BU"];
                    bindYear();
                }
                else
                {
                    ddl_Bunit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                    bindYear();
                }
             
                if (Request.QueryString.ToString().Length > 0)
                {
                    ddl_Year.SelectedValue = Request.QueryString["YR"];
                    bindEventCode();
                }
               
                if (Request.QueryString.ToString().Length > 0)
                {
                    ddl_eventcode.SelectedValue = Request.QueryString["EC"];
                    bindWorkAreas();
                    bindGrid();
                }
                hdfBU.Value = ddl_Bunit.SelectedValue;
                hdfYR.Value = ddl_Year.SelectedValue;
                hdfEC.Value = ddl_eventcode.SelectedValue;
            }            
           
        }
        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_BSUNIT_WA, ddl_Bunit);
            }
            catch
            {
            }
        }
        void bindYear()
        {
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_YEAR_WA, OledbParams, ddl_Year);
            }
            catch
            {
            }
        }
        void bindEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_EVTCODE_WA_COMP, OledbParams, ddl_eventcode);
            }
            catch
            {
            }
        }
        void bindCompany()
        {
            try
            {
                //DataAccessUtility.BindListboxWithoutConditionViaProcedure(m_SP_SELECT_COMPANY_FOR_WA, lst_Company);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Convert.ToInt32(ddl_Bunit.SelectedValue)));
                DataAccessUtility.BindListboxWithConditionViaProcedure(m_SP_SELECT_COMPANY_FOR_WA, OledbParams, lst_Company);
            }
            catch
            {
            }
        }
        void bindWorkAreas()
        {
            try
            {
                if (ddl_eventcode.SelectedIndex >= 0)
                {
                    lst_selWorkArea.Items.Clear();
                    List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                    OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Convert.ToInt32(ddl_Bunit.SelectedValue)));
                    OledbParams.Add(new OleDbParameter("V_YEAR", Convert.ToInt32(ddl_Year.SelectedValue)));
                    OledbParams.Add(new OleDbParameter("V_EVENT_CODE", ddl_eventcode.SelectedValue));
                    DataAccessUtility.BindListboxWithConditionViaProcedure(m_SP_SELECT_WA_FOR_EVCODE, OledbParams, lst_WorkArea);
                }
                else
                {
                    lst_WorkArea.Items.Clear();
                    lst_selWorkArea.Items.Clear();
                }
            }
            catch
            {
            }
        }

        protected void ddl_eventcode_SelectedIndexChanged(object sender, EventArgs e)
        {
            
           // bindWorkAreas();
            bindGrid();
            ResetControl();
        }

        protected void ddl_eventcode_DataBound(object sender, EventArgs e)
        {
            
            // bindWorkAreas();
            bindGrid();
            ResetControl();
        }

        protected void btn_addWA_Click(object sender, EventArgs e)
        {
            try
            {
                if (lst_WorkArea.SelectedValue.ToString().Trim() != "")
                {
                    foreach (ListItem item in this.lst_WorkArea.Items)
                    {
                        if (item.Selected)
                        {
                            this.lst_selWorkArea.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }


                    for (int i = lst_WorkArea.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_WorkArea.Items[i].Selected)
                        {
                            lst_WorkArea.Items.RemoveAt(i);
                        }

                    }

                }
                else
                {
                    foreach (ListItem item in this.lst_WorkArea.Items)
                    {
                        if (item.Value.ToString().Trim() != "")
                        {
                            this.lst_selWorkArea.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }

                    for (int i = lst_WorkArea.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_WorkArea.Items[i].Value.ToString() != "")
                        {
                            lst_WorkArea.Items.RemoveAt(i);
                        }

                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_addComp_Click(object sender, EventArgs e)
        {
            try
            {
                if (lst_Company.SelectedValue.ToString().Trim() != "")
                {
                    foreach (ListItem item in this.lst_Company.Items)
                    {
                        if (item.Selected)
                        {
                            this.lst_selCompany.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }

                    for (int i = lst_Company.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_Company.Items[i].Selected)
                        {
                            lst_Company.Items.RemoveAt(i);
                        }

                    }

                }
                else
                {
                    foreach (ListItem item in this.lst_Company.Items)
                    {
                        if (item.Value.ToString().Trim() != "")
                        {
                            this.lst_selCompany.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }

                    for (int i = lst_Company.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_Company.Items[i].Value.ToString() != "")
                        {
                            lst_Company.Items.RemoveAt(i);
                        }

                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_remWA_Click(object sender, EventArgs e)
        {
            try
            {
                foreach (ListItem item in this.lst_selWorkArea.Items)
                {
                    if (item.Selected)
                    {
                        this.lst_WorkArea.Items.Add(new ListItem(item.Text, item.Value));
                    }
                }


                for (int i = lst_selWorkArea.Items.Count - 1; i >= 0; i--)
                {
                    if (lst_selWorkArea.Items[i].Selected)
                    {
                        lst_selWorkArea.Items.RemoveAt(i);
                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_remComp_Click(object sender, EventArgs e)
        {
            try
            {
                foreach (ListItem item in this.lst_selCompany.Items)
                {
                    if (item.Selected)
                    {
                        this.lst_Company.Items.Add(new ListItem(item.Text, item.Value));
                    }
                }

                for (int i = lst_selCompany.Items.Count - 1; i >= 0; i--)
                {
                    if (lst_selCompany.Items[i].Selected)
                    {
                        lst_selCompany.Items.RemoveAt(i);
                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_add1_Click(object sender, EventArgs e)
        {
            try
            {
                if (lst_selWorkArea.Items.Count == 0)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('No WorkArea Selected!')", true);
                    return;
                }

                if (lst_selCompany.Items.Count == 0)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('No Company Selected!')", true);
                    return;
                }


                foreach (ListItem itemC in this.lst_selCompany.Items)
                {

                    foreach (ListItem itemW in this.lst_selWorkArea.Items)
                    {
                        AddDelete("INSERT", Int32.Parse(ddl_Year.SelectedValue), Int32.Parse(ddl_eventcode.SelectedValue), Int32.Parse(itemW.Value), Int32.Parse(itemC.Value));

                    }
                    createrateassign(Int32.Parse(ddl_Bunit.SelectedValue), Int32.Parse(ddl_Year.SelectedValue), Int32.Parse(ddl_eventcode.SelectedValue), Int32.Parse(itemC.Value));
                }


                bindGrid();
                ResetControl();
            }
            catch
            {
            }
        }

        private void createrateassign(Int32 V_BUSINESS_UNIT_ID, Int32 V_RATE_YEAR_ID, Int32 V_EVENT_CODE_ID , Int32 V_COMPANY_ID)
        {
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                sqlParams.Add(new OleDbParameter("V_RATE_YEAR_ID", V_RATE_YEAR_ID));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_WA_RATES_COMPANY_ASSGN, sqlParams);


            }
            catch { }
            finally
            {
            }
        }


        private void bindGrid()
        {
            gdv_WA_Company.DataBind();
            string V_EVENT_CODE = "";
            try
            {
                V_EVENT_CODE = ddl_eventcode.SelectedValue;

                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                
                OleDbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Convert.ToInt32(ddl_Bunit.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("V_YEAR", Convert.ToInt32(ddl_Year.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE", V_EVENT_CODE));


                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_SELECT_WORKAREA_COMPANY, OleDbParams, gdv_WA_Company);
            }
            catch
            {
            }
        }

        private void ResetControl()
        {
            lst_selCompany.Items.Clear();
            lst_selWorkArea.Items.Clear();

            bindWorkAreas();
            bindCompany();

            if (gdv_WA_Company.Rows.Count == 0)
            {
                btn_expExcel.Visible = false;
            }
            else
            {
                btn_expExcel.Visible = true;
            }
        }

        private void AddDelete(string strOperation, int YEAR_ID, int EVENT_CODE_ID, int WORK_AREA_ID, int COMPANY_ID)
        {
           int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_YEAR_ID", YEAR_ID));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE", EVENT_CODE_ID));
                sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", WORK_AREA_ID));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", COMPANY_ID));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
               // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_WA_COMPANY_INS_DEL, sqlParams);
               

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                
               
               // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Trimming started. Could not be deleted.')", true);
            }

        }

        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindYear();
        }

        protected void ddl_Year_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindEventCode();
        }

        protected void ddl_Year_DataBound(object sender, EventArgs e)
        {
            bindEventCode();
        }

        protected void ddl_Bunit_DataBound(object sender, EventArgs e)
        {
            try
            {
                bindYear();
               // ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
            }
            catch
            {
            }
        }

        protected void gdv_WA_Company_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            try
            {
                GridViewRow row = (GridViewRow)gdv_WA_Company.Rows[e.RowIndex];
                int YEAR_ID = Int32.Parse(ddl_Year.SelectedValue);
                int EVENT_CODE_ID = Int32.Parse(ddl_eventcode.SelectedValue);
                int COMPANY_ID = Convert.ToInt32((row.FindControl("lbl_COMPANY_ID") as Label).Text);
                int WORK_AREA_ID = Convert.ToInt32((row.FindControl("lbl_WORK_AREA_ID") as Label).Text);
                AddDelete("DELETE", YEAR_ID, EVENT_CODE_ID, WORK_AREA_ID, COMPANY_ID);

                bindGrid();
            }
            catch
            {
            }
        }

        protected void gdv_WA_Company_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[5].Visible = false;
            e.Row.Cells[6].Visible = false;
            //checks user role
            //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
            if (hdn_role.Value == "2")
            {
                e.Row.Cells[4].Visible = true;
            }
            else if (hdn_role.Value == "3")
            {
                e.Row.Cells[4].Visible = true;
            }
            else if (hdn_role.Value == "1")
            {
                e.Row.Cells[4].Visible = false;
            }
            
        }

        protected void btnAddRate_Click(object sender, EventArgs e)
        {
            Response.Redirect("Rates_Company.aspx?BU=" + ddl_Bunit.SelectedValue + "&EC=" + ddl_eventcode.SelectedValue + "&YR=" + ddl_Year.SelectedValue);
        }

       
        protected void btn_expExcel_Click(object sender, EventArgs e)
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddl_Bunit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddl_Year.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddl_eventcode.SelectedItem.Text);
                List<int> listColumnIndex = new List<int>(new int[] { 3 });
                VDMUtil.ExportGridToExcel(gdv_WA_Company, "Project-WorkArea-Company", "Workarea_Company", dictionaryFilters, listColumnIndex);
            }
            catch
            {
            }
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }

        protected void LinkButton1_Click(object sender, EventArgs e)
        {

        }


    }
}