﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.SqlClient;

namespace VMT
{
    public partial class Work_status : System.Web.UI.Page
    {
        string m_SP_SELECT_WORK_STATUS = Properties.Settings.Default.SP_SELECT_WORK_STATUS;
        string m_SP_VDM_WORK_STATUS_INS_UPD = Properties.Settings.Default.SP_VDM_WORK_STATUS_INS_UPD;
        string m_SP_SELECT_WORK_STATUS_DETAIL = Properties.Settings.Default.SP_SELECT_WORK_STATUS_DETAIL;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Work Status";

        protected void Page_Load(object sender, EventArgs e)
        {
           

            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            //if (userRole == "Edit")
            //{
            //    btn_add.Visible = true;
            //}
            //else
            //{
            //    btn_add.Visible = false;
            //}

            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                bindGrid();
                btn_create.Visible = false;
                btn_delete.Visible = false;

            }
        }
        private void bindGrid()
        {
            try
            {
                DataAccessUtility.BindGridViewViaProcedure(m_SP_SELECT_WORK_STATUS, gdv_list);
                gdv_list.SelectedIndex = -1;
            }
            catch
            {
            }
        }
        protected void btn_add_Click(object sender, EventArgs e)
        {
            if (btn_add.Text == "Add New")
            {
                AddUpdate("INSERT");
            }
            else if (btn_add.Text == "Update")
            {
                AddUpdate("UPDATE");
            }
        }

        private void AddUpdate(string strOperation)
        {
            if (txt_desc.Text.Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Work Status could not be blank!')", true);
                //Response.Write("<script LANGUAGE='JavaScript' >alert('Company name could not be blank!')</script>");
                return;
            }
            int WorkStatus_id = 0;
            if (strOperation == "INSERT")
            {
                WorkStatus_id = 0;
            }
            else
            {
                WorkStatus_id = Int32.Parse(hdn_keyid.Value);
            }

            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_WORK_STATUS_ID", WorkStatus_id));
                sqlParams.Add(new OleDbParameter("V_WORK_STATUS_DESCRIPTION", txt_desc.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
               // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_WORK_STATUS_INS_UPD, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                bindGrid();
               clearfields();
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Work Status already exists')", true);
            }

        }

        void clearfields()
        {
            btn_create.Visible = false;
            btn_delete.Visible = false;
            hdn_keyid.Value = "";
            btn_add.Text = "Add New";
            txt_desc.Text = "";
           

        }

        protected void gdv_list_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
        {
            GridViewRow row = gdv_list.Rows[e.NewSelectedIndex];
            hdn_keyid.Value = row.Cells[1].Text;

         //   if (userRole == "3")
         //   {
                btn_add.Text = "Update";
                btn_create.Visible = true;
                btn_delete.Visible = true;
        //    }
            getdetail();
        }
        void getdetail()
        {
            DataSet ds = new DataSet();
            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                OleDbParams.Add(new OleDbParameter("V_WORK_STATUS_ID", hdn_keyid.Value));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SELECT_WORK_STATUS_DETAIL, OleDbParams);


                //bind the fields 

                txt_desc.Text = ds.Tables[0].Rows[0]["WORK_STATUS_DESCRIPTION"].ToString();

            }
            catch
            {
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }

        protected void btn_reset_Click(object sender, EventArgs e)
        {
            if (hdn_keyid.Value == "")
            {
                clearfields();
            }

            else
            {
                getdetail();
            }
        }

        protected void btn_delete_Click(object sender, EventArgs e)
        {
            AddUpdate("DELETE");
        }

        protected void btn_create_Click(object sender, EventArgs e)
        {
            clearfields();
        }

        protected void gdv_list_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[1].Visible = false; // hides the first column
        }
    }
}