﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;

namespace VMT
{
    public partial class WorkArea_Rates : System.Web.UI.Page
    {
       
        string m_SP_VDM_SELECT_BSUNIT_WA = Properties.Settings.Default.SP_VDM_SELECT_BSUNIT_WA;
        string m_SP_VDM_SELECT_YEAR_WA = Properties.Settings.Default.SP_VDM_SELECT_YEAR_WA;
        string m_SP_VDM_SELECT_EVENTCODE = Properties.Settings.Default.SP_VDM_SELECT_EVENTCODE;
        string m_SP_VDM_SELECT_RATE_TYPES_WA = Properties.Settings.Default.SP_VDM_SELECT_RATE_TYPES_WA;        
        string m_SP_SELECT_WA_FOR_EVCODE = Properties.Settings.Default.SP_SELECT_WA_FOR_EVCODE;
        string m_SP_VDM_SELECT_WA_COMPANY_RATES = Properties.Settings.Default.SP_VDM_SELECT_WA_COMPANY_RATES;
        


        
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                bindBusinessUnit();
                bindRates();

            }
            
        }
        private void bindGrid()
        {
            gdv_WA_Rate.DataBind();
            string V_EVENT_CODE = "";
            try
            {
                V_EVENT_CODE = ddl_eventcode.SelectedValue;

                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE", V_EVENT_CODE));
                DataAccessUtility.BindGridViewWithConditionViaProcedure("m_SP_VDM_SELECT_WA_COMPANY_RATES", OleDbParams, gdv_WA_Rate);
            }
            catch
            {
            }
        }
        private void ResetControl()
        {
            lst_selRate.Items.Clear();
            lst_selWorkArea.Items.Clear();

            bindWorkAreas();
            bindRates();
        }
        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_BSUNIT_WA, ddl_Bunit);
            }
            catch
            {
            }
        }
        void bindRates()
        {
            try
            {
                DataAccessUtility.BindListboxWithoutConditionViaProcedure(m_SP_VDM_SELECT_RATE_TYPES_WA, lst_Rate);
            }
            catch
            {
            }
        }
        void bindYear()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_YEAR_WA, ddl_Year);
            }
            catch
            {
            }
        }
        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindEventCode();
        }
        void bindEventCode()
        {


            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_EVENTCODE, OledbParams, ddl_eventcode);
            }
            catch
            {
            }
        }

        protected void ddl_Year_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindEventCode();
        }

        protected void ddl_Year_DataBound(object sender, EventArgs e)
        {
            bindEventCode();
        }

        protected void ddl_Bunit_DataBound(object sender, EventArgs e)
        {
            bindYear(); 
        }

        protected void ddl_eventcode_SelectedIndexChanged(object sender, EventArgs e)
        {

            bindWorkAreas();
           // bindGrid();
        }

        protected void ddl_eventcode_DataBound(object sender, EventArgs e)
        {

            bindWorkAreas();
            //bindGrid();
        }
        void bindWorkAreas()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE", ddl_eventcode.SelectedValue));
                DataAccessUtility.BindListboxWithConditionViaProcedure(m_SP_SELECT_WA_FOR_EVCODE, OledbParams, lst_WorkArea);
            }
            catch
            {
            }
        }

        protected void btn_addWA_Click(object sender, EventArgs e)
        {
            try
            {
                foreach (ListItem item in this.lst_WorkArea.Items)
                {
                    if (item.Selected)
                    {
                        this.lst_selWorkArea.Items.Add(new ListItem(item.Text, item.Value));
                    }
                }


                for (int i = lst_WorkArea.Items.Count - 1; i >= 0; i--)
                {
                    if (lst_WorkArea.Items[i].Selected)
                    {
                        lst_WorkArea.Items.RemoveAt(i);
                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_remWA_Click(object sender, EventArgs e)
        {
            try
            {
                foreach (ListItem item in this.lst_selWorkArea.Items)
                {
                    if (item.Selected)
                    {
                        this.lst_WorkArea.Items.Add(new ListItem(item.Text, item.Value));
                    }
                }


                for (int i = lst_selWorkArea.Items.Count - 1; i >= 0; i--)
                {
                    if (lst_selWorkArea.Items[i].Selected)
                    {
                        lst_selWorkArea.Items.RemoveAt(i);
                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_addRate_Click(object sender, EventArgs e)
        {
            if (lst_Rate.SelectedValue.ToString().Trim() != "0")
            {
                foreach (ListItem item in this.lst_Rate.Items)
                {
                    if (item.Selected)
                    {
                        this.lst_selRate.Items.Add(new ListItem(item.Text, item.Value));
                    }
                }

                for (int i = lst_Rate.Items.Count - 1; i >= 0; i--)
                {
                    if (lst_Rate.Items[i].Selected)
                    {
                        lst_Rate.Items.RemoveAt(i);
                    }

                }

            }
            else
            {
                foreach (ListItem item in this.lst_Rate.Items)
                {
                    if (item.Value.ToString().Trim() != "0")
                    {
                        this.lst_selRate.Items.Add(new ListItem(item.Text, item.Value));
                    }
                }

                for (int i = lst_Rate.Items.Count - 1; i >= 0; i--)
                {
                    if (lst_Rate.Items[i].Value.ToString() != "0")
                    {
                        lst_Rate.Items.RemoveAt(i);
                    }

                }

            }
        }

        protected void btn_remRate_Click(object sender, EventArgs e)
        {
            foreach (ListItem item in this.lst_selRate.Items)
            {
                if (item.Selected)
                {
                    this.lst_Rate.Items.Add(new ListItem(item.Text, item.Value));
                }
            }

            for (int i = lst_selRate.Items.Count - 1; i >= 0; i--)
            {
                if (lst_selRate.Items[i].Selected)
                {
                    lst_selRate.Items.RemoveAt(i);
                }

            }
        }

        protected void btn_add1_Click(object sender, EventArgs e)
        {
            try
            {
                if (lst_selWorkArea.Items.Count == 0)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('No WorkArea Selected!')", true);
                    return;
                }

                if (lst_selRate.Items.Count == 0)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('No Company Selected!')", true);
                    return;
                }


                foreach (ListItem itemC in this.lst_selRate.Items)
                {

                    foreach (ListItem itemW in this.lst_selWorkArea.Items)
                    {
                        AddDelete("INSERT", Int32.Parse(itemW.Value), Int32.Parse(itemC.Value));

                    }
                }


                bindGrid();
                ResetControl();
            }
            catch
            {
            }
        }

        private void AddDelete(string strOperation, int WORK_AREA_ID, int COMPANY_ID)
        {
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", WORK_AREA_ID));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", COMPANY_ID));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
             //   retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_WA_COMPANY_INS_DEL, sqlParams);


            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {


                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Work_Area Company already exists')", true);
            }

        }
    }
}