﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.OleDb;
using DataAccess;
using System.Data;


namespace VMT
{
    public partial class WorkArea : System.Web.UI.Page
    {
        string m_SP_SELECT_BUSINESS_UNIT = Properties.Settings.Default.SP_SELECT_BUSINESS_UNIT;
        string m_SP_VDM_SELECT_YR_MOVE_CYCLE = Properties.Settings.Default.SP_VDM_SELECT_YR_MOVE_CYCLE;
        string m_SP_VDM_WORKAREA_INS_UPD = Properties.Settings.Default.SP_VDM_EC_WA_INS_UPD;
        string m_SP_SELECT_WORK_AREA = Properties.Settings.Default.SP_SELECT_WORK_AREA;
        string m_SP_SELECT_SINGLE_WORK_AREA = Properties.Settings.Default.SP_VDM_SELECT_EXIST_EVENT_CODE;

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                bindGrid();
                bindBusinessUnit();
                BindCycle();
                BindYear(ddlCycleYr);
                ddlCycleYr.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                CalculateTrimYearTgt();
                btnDelete.Visible = false;
            }
        }

        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SELECT_BUSINESS_UNIT, ddl_Bunit);
            }
            catch
            {
            }
        }

        protected void gdvWorkArea_Sorting(object sender, GridViewSortEventArgs e)
        {
            try
            {
                VDMUtil.GridviewSorting(gdvWorkArea, e.SortExpression, (DataSet)ViewState["dataTable"]);
            }
            catch
            {
            }
        }

        private void bindGrid()
        {
            try
            {
                DataAccessUtility.BindGridViewViaProcedure(m_SP_SELECT_WORK_AREA, gdvWorkArea);
                ViewState["dataTable"] = gdvWorkArea.DataSource as DataSet;
            }
            catch
            {
            }
        }
        void BindCycle()
        {
            ddlCycle.Items.AddRange(Enumerable.Range(1, 9).Select(e => new ListItem(e.ToString())).ToArray());
            ddlCycle.SelectedValue = Properties.Settings.Default.SELECTED_CYCLE;
        }  
        protected void btnSubmit_Click(object sender, EventArgs e)
        {
            if (btnSubmit.Text == "Add New")
            {
                AddUpdate("INSERT");
            }
            else if (btnSubmit.Text == "Update")
            {
                AddUpdate("UPDATE");
            }
        }

        private void AddUpdate(string strOperation)
        {
            int WorkArea_id = 0;
            if (txtSectionCode.Text.Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Section code could not be blank!')", true);
                return;
            }
            if (txtWADescription.Text.Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Work area description could not be blank!')", true);
                return;
            }
            if (strOperation == "INSERT")
            {
                WorkArea_id = 0;
            }
            else
            {
                WorkArea_id = Int32.Parse(hd_WorkareaId.Value);
            }

            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", WorkArea_id));
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Int32.Parse(ddl_Bunit.SelectedValue.Trim())));
                sqlParams.Add(new OleDbParameter("V_SECTION_CODE", txtSectionCode.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_CYCLE", Int32.Parse(ddlCycle.SelectedValue.Trim())));
                sqlParams.Add(new OleDbParameter("V_WORKAREA_DESCRIPTION", txtWADescription.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_CYCLE_YEAR", Int32.Parse(ddlCycleYr.SelectedValue.Trim())));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_WORKAREA_INS_UPD, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                bindGrid();
                clearfields();
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " SUCCESSFULL.')", true);
                btnDelete.Visible = false;

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Workarea already exists')", true);
            }

        }

        void clearfields()
        {
            //btn_create.Visible = false;
            //btn_delete.Visible = false;
            hd_WorkareaId.Value = "";
            btnSubmit.Text = "Add New";
            txtSectionCode.Text = "";
            txtWADescription.Text = "";


        }

        protected void ddlCycle_SelectedIndexChanged(object sender, EventArgs e)
        {
            CalculateTrimYearTgt();
        }
        void CalculateTrimYearTgt()
        {
            txtFTYT.Text = (Int32.Parse(ddlCycleYr.SelectedItem.Text) + Int32.Parse(ddlCycle.SelectedValue)).ToString();
            txtFFTYT.Text = (Int32.Parse(txtFTYT.Text) + Int32.Parse(ddlCycle.SelectedValue)).ToString();

        }

        void BindYear(DropDownList ddlYr)
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_YR_MOVE_CYCLE, ddlYr);
            }
            catch
            {
            }
        }

        protected void ddlCycleYr_SelectedIndexChanged(object sender, EventArgs e)
        {
            CalculateTrimYearTgt();
        }

        protected void btnDelete_Click(object sender, EventArgs e)
        {
            AddUpdate("DELETE");
        }

        protected void gdvWorkArea_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
        {
            GridViewRow row = gdvWorkArea.Rows[e.NewSelectedIndex];
            hd_WorkareaId.Value = row.Cells[2].Text;
            btnSubmit.Text = "Update";
            btnDelete.Visible = true;
            getdetail();
        }

        void getdetail()
        {
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            try
            {
                OleDbParams.Add(new OleDbParameter("V_WORK_AREA_ID", hd_WorkareaId.Value));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SELECT_SINGLE_WORK_AREA, OleDbParams);


                //bind the fields 
                ddl_Bunit.SelectedValue = ds.Tables[0].Rows[0]["business_unit_id"].ToString();
                txtSectionCode.Text = ds.Tables[0].Rows[0]["old_section_code"].ToString();
                ddlCycle.SelectedValue = ds.Tables[0].Rows[0]["trim_cycle"].ToString();
                txtWADescription.Text = ds.Tables[0].Rows[0]["work_area_description"].ToString();
                ddlCycleYr.SelectedValue = ds.Tables[0].Rows[0]["TRIM_YEAR_TARGET"].ToString();
                txtFTYT.Text = ds.Tables[0].Rows[0]["FTYT"].ToString();
                txtFFTYT.Text = ds.Tables[0].Rows[0]["FFTYT"].ToString();
            }
            catch
            {
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }
    }
}