﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Data.SqlClient;
using DataAccess;
using System.IO;

namespace VMT
{
    public static class VDMUtil
    {
        public static void ExportGridToExcel(GridView gdvExportExcel,string headerTitle, string fileName, Dictionary<string, string> discFilters, List<int> listHideColumns)
        {
            try
            {

                System.Web.HttpContext.Current.Response.Clear();
                System.Web.HttpContext.Current.Response.Buffer = true;
                System.Web.HttpContext.Current.Response.ClearContent();
                System.Web.HttpContext.Current.Response.ClearHeaders();
                System.Web.HttpContext.Current.Response.Charset = "";
                string FileName = fileName +"-" + DateTime.Now + ".xls";
                StringWriter strwritter = new StringWriter();
                HtmlTextWriter htmltextwrtter = new HtmlTextWriter(strwritter);
                System.Web.HttpContext.Current.Response.Cache.SetCacheability(HttpCacheability.NoCache);
                System.Web.HttpContext.Current.Response.ContentType = "application/vnd.ms-excel";
                System.Web.HttpContext.Current.Response.AddHeader("Content-Disposition", "attachment;filename=" + FileName);

                strwritter.WriteLine("<b><center><font size='4'>" + headerTitle + "</font></center></b>");
                strwritter.WriteLine("<center><font size='3'> Generated On: " + DateTime.Now + "</font></center>");
                strwritter.WriteLine("<center><font size='3'> By: " + System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper() + "</font></center><br>");

                if (listHideColumns != null)
                {
                    foreach (int indx in listHideColumns)
                    {
                        gdvExportExcel.Columns[indx].Visible = false;
                    }
                }

                if (discFilters != null)
                {
                    foreach (var pair in discFilters)
                    {
                        strwritter.WriteLine("{0}: {1}", "<b><left><font size='3'>" + pair.Key + "</b>", pair.Value + "</font></left><br>");
                    }
                    strwritter.WriteLine("<br>");
                }
                                
                gdvExportExcel.GridLines = GridLines.Both;
                gdvExportExcel.HeaderStyle.Font.Bold = true;
                gdvExportExcel.RenderControl(htmltextwrtter);

                System.Web.HttpContext.Current.Response.Write(strwritter.ToString());
                System.Web.HttpContext.Current.Response.End();
            }
            catch { }
            finally
            {
            }
        }

        

        //Gridview sorting
        private static string _sortDirection;
        
        public static string GridviewSorting(GridView gdv_TotMilesAmt, string SortExpression, DataSet dsTotMilesGrid)
        {
            Image sortImage = new Image();
            if (System.Web.HttpContext.Current.Session["SortDireaction"] == null)
                _sortDirection = string.Empty;
            else
                _sortDirection = System.Web.HttpContext.Current.Session["SortDireaction"].ToString();
            SetSortDirection(_sortDirection, sortImage);
            DataSet ds = dsTotMilesGrid;
            DataView dv = new DataView(ds.Tables[0]);
            DataTable dataTable = dv.ToTable();
            if (dataTable != null)
            {
                //Sort the data.
                dataTable.DefaultView.Sort = SortExpression + " " + _sortDirection;
                gdv_TotMilesAmt.DataSource = dataTable;
                gdv_TotMilesAmt.DataBind();
                System.Web.HttpContext.Current.Session["SortDireaction"] = _sortDirection;
                int columnIndex = 0;
                foreach (DataControlFieldHeaderCell headerCell in gdv_TotMilesAmt.HeaderRow.Cells)
                {
                    if (headerCell.ContainingField.SortExpression == SortExpression)
                    {
                        columnIndex = gdv_TotMilesAmt.HeaderRow.Cells.GetCellIndex(headerCell);
                    }
                }

                gdv_TotMilesAmt.HeaderRow.Cells[columnIndex].Controls.Add(sortImage);
            }
            return _sortDirection;
        }

        public static void SetSortDirection(string sortDirection, Image sortImage)
        {
            if (sortDirection == "ASC")
            {
                _sortDirection = "DESC";
                sortImage.ImageUrl = "resource_gallery/graphics/downarrow.png";
            }
            else
            {
                _sortDirection = "ASC";
                sortImage.ImageUrl = "resource_gallery/graphics/uparrow.png";
            }
        }
    }
}