﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Data.OleDb;
using System.DirectoryServices.AccountManagement;
using System.Security;
using System.Globalization;
using DataAccess;

namespace VMT
{
    /// <summary>
    /// Summary description for UserRoleService
    /// </summary>
    [WebService(Namespace = "http://tempuri.org/")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    [System.ComponentModel.ToolboxItem(false)]
    // To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
    // [System.Web.Script.Services.ScriptService]
    public class UserRoleService : System.Web.Services.WebService
    {

        [WebMethod(Description = "checks user role for the page")]
        public string GetRole(string argStoredProcedureName, string pageTitle)
        {
            int result = 0;
            string all_Roles = "";
            try
            {

                using (PrincipalContext ctx = new PrincipalContext(ContextType.Domain))
                {
                    // find a user
                    UserPrincipal user = UserPrincipal.FindByIdentity(ctx, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                    
                    if (user != null)
                    {
                        // find the roles....
                        var roles = user.GetAuthorizationGroups();
                        // enumerate over them
                        foreach (Principal p in roles)
                        {
                            all_Roles = all_Roles + p + ",";
                        }
                        all_Roles = all_Roles.TrimEnd(',');
                    }

                    //string sarRoles = "APP_VMS_VIEW," + all_Roles;
                    string sarRoles = all_Roles;
                    //string sarRoles = "APP_VMS_SPRAY_VIEW," + all_Roles;
                    //string sarRoles = "APP_VMS_SPRAY_EDIT," + all_Roles;
                    //string sarRoles = "APP_VMS_ADMIN," + all_Roles;
                    List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                    sqlParams.Add(new OleDbParameter("V_USER_SAR_ROLES", sarRoles));
                    sqlParams.Add(new OleDbParameter("V_PAGE_TITLE", pageTitle));
                    result = DataAccessUtility.SelectSingleValueViaStoreProcedureParamWithOutPutParam(argStoredProcedureName, sqlParams);
                    //result = 3;
                }
            }
            catch (Exception Ex) { }
            finally
            {
            }

            return result.ToString();            
        }

        [WebMethod(Description = "checks the user role for the page")]
        public string GetUserRole(string argStoredProcedureName, string pageTitle, string Userid)
        {
            int result = 0;
            string all_Roles = "";
            try
            {

                using (PrincipalContext ctx = new PrincipalContext(ContextType.Domain))
                {
                    // find a user
                  //  UserPrincipal user = UserPrincipal.FindByIdentity(ctx, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                    UserPrincipal user = UserPrincipal.FindByIdentity(ctx, Userid);
                    if (user != null)
                    {
                        // find the roles....
                        var roles = user.GetAuthorizationGroups();
                        // enumerate over them
                        foreach (Principal p in roles)
                        {
                            all_Roles = all_Roles + p + ",";
                        }
                        all_Roles = all_Roles.TrimEnd(',');
                    }

                    //string sarRoles = "APP_VMS_VIEW," + all_Roles;
                    string sarRoles = all_Roles;
                    //string sarRoles = "APP_VMS_SPRAY_VIEW," + all_Roles;
                    //string sarRoles = "APP_VMS_SPRAY_EDIT," + all_Roles;
                    //string sarRoles = "APP_VMS_ADMIN," + all_Roles;
                    List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                    sqlParams.Add(new OleDbParameter("V_USER_SAR_ROLES", sarRoles));
                    sqlParams.Add(new OleDbParameter("V_PAGE_TITLE", pageTitle));
                    result = DataAccessUtility.SelectSingleValueViaStoreProcedureParamWithOutPutParam(argStoredProcedureName, sqlParams);
                    //result = 3;
                }
            }
            catch (Exception Ex) { }
            finally
            {
            }

            return result.ToString();
        }
        
    }
}
