﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.OleDb;
using System.Data;
using DataAccess;

namespace VMT
{
    public partial class TrimIssuesView : System.Web.UI.Page
    {
        string m_SP_TIV_SEL_BUSINESS_UNIT = Properties.Settings.Default.SP_TIV_SEL_BUSINESS_UNIT;
        string m_SP_TIV_SEL_EVENTCODE = Properties.Settings.Default.SP_TIV_SEL_EVENTCODE;
        string m_SP_TIV_SEL_WORKAREA = Properties.Settings.Default.SP_TIV_SEL_WORKAREA;
        string m_SP_TIV_SEL_FOREMAN = Properties.Settings.Default.SP_TIV_SEL_FOREMAN;
        string m_SP_TIV_SEL_TRIM_ISSUES = Properties.Settings.Default.SP_TIV_SEL_TRIM_ISSUES;
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Project Trim Issues";

        protected void Page_Load(object sender, EventArgs e)
        {
            

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                BindBusinessUnit();
                ddlBUnit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;

                BindEventCode();
               
            }

        }
        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_TIV_SEL_BUSINESS_UNIT, ddlBUnit);
               
            }
            catch
            {
            }
        }
        protected void ddlBUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindEventCode();
        }

       

        protected void ddlBUnit_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
        }
        void BindEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
           
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue); 
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_TIV_SEL_EVENTCODE, OledbParams, ddlEventCode);
            }
            catch
            {
            }

        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindWorkArea();
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            BindWorkArea();
        }
        void BindWorkArea()
        {
            int V_BUSINESS_UNIT_ID = 0;            
            int V_EVENT_CODE_ID = 0;

            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_TIV_SEL_WORKAREA, OledbParams, ddlWorkArea);
            }
            catch
            {
            }
        }

        protected void ddlWorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            Bindforeman();
        }

        protected void ddlWorkArea_DataBound(object sender, EventArgs e)
        {
            Bindforeman();
        }

        void Bindforeman()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_EVENT_CODE_ID = 0;
            int V_WORK_AREA_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                V_WORK_AREA_ID = Convert.ToInt32(ddlWorkArea.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_TIV_SEL_FOREMAN, OledbParams, ddlForeman);
            }
            catch
            {
            }
        }
        void BindBidGrid()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_EVENT_CODE_ID = 0;
            int V_WORK_AREA_ID = 0;
            int V_EMPLOYEE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Int32.Parse(ddlBUnit.SelectedValue.ToString());
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                V_WORK_AREA_ID = Convert.ToInt32(ddlWorkArea.SelectedValue);
                V_EMPLOYEE_ID = Convert.ToInt32(ddlForeman.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                OledbParams.Add(new OleDbParameter("V_EMPLOYEE_ID", V_EMPLOYEE_ID));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_TIV_SEL_TRIM_ISSUES, OledbParams, gdvWorkArea);
                ViewState["dataTable"] = gdvWorkArea.DataSource as DataSet;
                gdvWorkArea.SelectedIndex = -1;

                if (gdvWorkArea.Rows.Count > 0)
                {
                    //btnSave.Visible = true;
                    btnExportExcel.Visible = true;
                }
                else
                {
                    // btnSave.Visible = false;
                    btnExportExcel.Visible = false;
                }
            }
            catch
            {
            }
        }
        protected void btnGo_Click(object sender, EventArgs e)
        {
            BindBidGrid();
        }

        protected void gdvWorkArea_Sorting(object sender, GridViewSortEventArgs e)
        {
            VDMUtil.GridviewSorting(gdvWorkArea, e.SortExpression, (DataSet)ViewState["dataTable"]);
        }

        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
            dictionaryFilters.Add("Business Unit", ddlBUnit.SelectedItem.Text);
            dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
            dictionaryFilters.Add("Work Area", ddlWorkArea.SelectedItem.Text);
            dictionaryFilters.Add("Foreman", ddlForeman.SelectedItem.Text);
            VDMUtil.ExportGridToExcel(gdvWorkArea, "Issue List", "TrimIssue", dictionaryFilters, null);
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }
    }
}