﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TestMap.aspx.cs" Inherits="VMT.TestMap" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" style="height: 100%;">
<head runat="server">
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="author" content="" />
    <meta content="IE=Edge" http-equiv="X-UA-Compatible" />
    <title></title>

    <!-- Bootstrap core JavaScript -->
    <%--<script src="resource_gallery/js/jquery.min.js"></script>--%>
    <%--<script src="resource_gallery/js/bootstrap.min.js"></script>--%>

    <script src="resource_gallery/js/jquery-1.12.4.min.js"></script>
    <link href="resource_gallery/css/bootstrap.min.css" rel="stylesheet" />

    <!--For Accordion-->
    <style type="text/css">
        .panel-heading {
            position: relative;
        }

            .panel-heading[data-toggle="collapse"]:after {
                font-family: 'Glyphicons Halflings';
                content: "\e072"; /* "play" icon */
                position: absolute;
                color: #b0c5d8;
                font-size: 18px;
                line-height: 22px;
                right: 20px;
                top: calc(50% - 10px);
                /* rotate "play" icon from > (right arrow) to down arrow */
                -webkit-transform: rotate(-90deg);
                -moz-transform: rotate(-90deg);
                -ms-transform: rotate(-90deg);
                -o-transform: rotate(-90deg);
                transform: rotate(-90deg);
            }

            .panel-heading[data-toggle="collapse"].collapsed:after {
                /* rotate "play" icon from > (right arrow) to ^ (up arrow) */
                -webkit-transform: rotate(90deg);
                -moz-transform: rotate(90deg);
                -ms-transform: rotate(90deg);
                -o-transform: rotate(90deg);
                transform: rotate(90deg);
            }
    </style>
    <%--<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>--%>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css" rel="stylesheet" />
    <link href="resource_gallery/css/mapview.css" rel="stylesheet" />

    <%--Accordion click event--%>
    <script>
        $(document).ready(function () {
            $('ul.list-group li').click(function (e) {
                e.preventDefault();
                //set header text
                var header = $(this).find("span.t").text();
                $("#span-header").html(header);
                if ($('#span-header').text()) {
                    $('#img-back').css({ display: "inline" });
                } else {
                    $('#img-back').css({ display: "none" });
                }

                //Menu click
                if (header == "Layer Cotrols") {
                    $('#div-accordion').css({ display: "block" });
                    $('#div-menu').css({ display: "none" });
                }
                else if (header == "Filter") {
                    $('#div-filter').css({ display: "block" });
                    $('#div-menu').css({ display: "none" });
                }
                else if (header == "Search Result") {
                    $('#div-result').css({ display: "block" });
                    $('#div-menu').css({ display: "none" });
                }
                else if (header == "Details") {
                    $('#div-details').css({ display: "block" });
                    $('#div-menu').css({ display: "none" });
                }
                else if (header == "Assign") {
                    $('#div-assign').css({ display: "block" });
                    $('#div-menu').css({ display: "none" });
                }
                else if (header == "Status") {
                    $('#div-status').css({ display: "block" });
                    $('#div-menu').css({ display: "none" });
                }
                else {
                    $('#div-accordion').css({ display: "none" });
                    $('#div-filter').css({ display: "none" });
                    $('#div-menu').css({ display: "block" });
                }



                //Back image click. Hide all the div except menu
                $('#img-back').click(function () {
                    $('#img-back').css({ display: "none" });
                    $('#div-menu').css({ display: "block" });
                    $('#div-accordion').css({ display: "none" });
                    $('#div-filter').css({ display: "none" });
                    $('#div-result').css({ display: "none" });
                    $('#div-details').css({ display: "none" });
                    $('#div-assign').css({ display: "none" });
                    $('#div-status').css({ display: "none" });
                    $("#span-header").html('');
                });
            });
        });
    </script>

    <%--Map--%>
    <link rel="stylesheet" href="http://js.arcgis.com/3.12/esri/css/esri.css" />
    <style type="text/css">
        @import "http://js.arcgis.com/3.12/dijit/themes/claro/claro.css";
    </style>
    <script type="text/javascript">

        function Mapview(v) {
            //To Do
            switch (v) {
                case "Road":
                    //Road
                    veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_ROAD); return false;
                    break;
                case "Aerial":
                    //Aerial
                    veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_AERIAL); return false;
                    break;
                case "Aerialp":
                    //Aerial with Label
                    veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_AERIAL_WITH_LABELS); return false;
                    break;
            }
        };

    </script>
    <script src="http://js.arcgis.com/3.12/"></script>
    <script type="text/javascript">
        var map, map1, map2, featureLayer, defaultSymbol, highlightSymbol, resultTemplate;
        var v_Dynamic_BaseLayer_ElectricDistribution;
        var s_Dynamic_BaseLayer_ElectricDistribution;
        s_Dynamic_BaseLayer_ElectricDistribution = "<%= System.Configuration.ConfigurationManager.AppSettings["BaseLayer_ElectricDistribution"].ToString() %>";




      var imageParametersbmt;
      var dynamicMapServiceLayerbmt;
      var dynamicurlbmt = "<%= System.Configuration.ConfigurationManager.AppSettings["Dynamic_MapService_BASEMAP_DIST"].ToString() %>";

        var imageParametersbmtt;
        var dynamicMapServiceLayerbmtt;
        var dynamicurlbmtt = "<%= System.Configuration.ConfigurationManager.AppSettings["Dynamic_MapService_BASEMAP_TRANS"].ToString() %>";

        var flightUrl = "<%= System.Configuration.ConfigurationManager.AppSettings["MapService_Flight_Issues"].ToString() %>";
        var trimUrl = "<%= System.Configuration.ConfigurationManager.AppSettings["MapService_Trim_Dist_Lines"].ToString() %>";
        var distUrl = "<%= System.Configuration.ConfigurationManager.AppSettings["MapService_Gas_Dist_Lines"].ToString() %>";
        var tranUrl = "<%= System.Configuration.ConfigurationManager.AppSettings["MapService_Gas_Trans_Lines"].ToString() %>";






        require([
          "esri/map",
          "esri/tasks/locator",
          "esri/graphic",
          "esri/toolbars/navigation",
          "esri/toolbars/draw",
          "dojo/on",
          "esri/tasks/QueryTask",
          "esri/tasks/query",

          "esri/InfoTemplate",
          "esri/symbols/SimpleMarkerSymbol",
          "dojo/_base/array",
          "esri/symbols/TextSymbol",
          "esri/Color",
          "esri/symbols/Font",
          "esri/layers/ArcGISDynamicMapServiceLayer",
          "esri/layers/ImageParameters",
          "dojo/parser",
          "esri/SpatialReference",
          "dojo/dom",
          "dijit/registry",
           "esri/virtualearth/VETiledLayer",
          "dijit/Toolbar",

          "esri/layers/FeatureLayer",
          "dijit/form/Button",
          "dojo/number",
          "dijit/form/Textarea",
          "dijit/layout/BorderContainer",
          "dijit/layout/ContentPane",
          "dojo/domReady!"
        ],
          function (
              Map,
              Locator,
              Graphic,
              Navigation,
              Draw,
              on,
              QueryTask,
              Query,
              InfoTemplate,
              SimpleMarkerSymbol,
              arrayUtils,
              TextSymbol,
              Color,
              Font,
              ArcGISDynamicMapServiceLayer,
              ImageParameters,
              parser,
              SpatialReference,
              dom,
              registry,
              FeatureLayer,
              number

           ) {

              parser.parse();
              var navToolbar;

              map = new Map("map", {
                  basemap: "streets",
                  center: [-81.0324, 33.9897],
                  spatialReference: { wkid: 4269 },
                  zoom: 15,
                  setDisableClientCaching: true
              });

              map.on("load", initSelectToolbar);

              veTileLayer = new esri.virtualearth.VETiledLayer({
                  bingMapsKey: "Ajnso1rASr162jqnreomXwwRjjpAxTYzPzQmoVMIdI0kPN2vC415f7brraeZ-B5j",
                  mapStyle: esri.virtualearth.VETiledLayer.MAP_STYLE_ROAD
              });
              map.addLayer(veTileLayer);
              //initialize select toolbar
              function initSelectToolbar(event) {
                  selectionToolbar = new esri.toolbars.Draw(event.map);
                  var selectQuery = new esri.tasks.Query();

                  on(selectionToolbar, "DrawEnd", function (geometry) {
                      selectionToolbar.deactivate();
                      selectQuery.geometry = geometry;
                      featureLayer.selectFeatures(selectQuery,
                        FeatureLayer.SELECTION_NEW);
                  });
              }

              addDynamicServiceLayer(dynamicurlbmt)
              addDynamicServiceLayer(dynamicurlbmtt)
              addDynamicServiceLayer(flightUrl)

              // Add feature Layer


              AddFeaturewithnoPopup(flightUrl);
              AddFeaturewithnoPopup(trimUrl);
              AddFeaturewithnoPopup(distUrl);
              AddFeaturewithnoPopup(tranUrl);



              function AddFeaturewithnoPopup(feature_layer) {
                  //info template for points returned
                  resultTemplate = new esri.InfoTemplate("SEQUENCER", "${SEQUENCER}");

                  var featureLayerUrl = feature_layer;
                  featureLayer = new esri.layers.FeatureLayer(featureLayerUrl, {
                      mode: esri.layers.FeatureLayer.MODE_ONDEMAND,
                      infoTemplate: resultTemplate,
                      outFields: ["OBJECTID", "SEQUENCER"]
                  });


                  ////on selection of the region
                  //featureLayer.on("selection-complete", findPointsInExtent);
                  map.addLayer(featureLayer);
              }

              function addDynamicServiceLayer(dynamicurl) {

                  // adding Dynamic service layers
                  var imageParameters = new ImageParameters();
                  imageParameters.format = "jpeg";
                  dynamicMapServiceLayerbmt = new ArcGISDynamicMapServiceLayer(dynamicurl, {
                      "opacity": 0.5,
                      visible: true,
                      "imageParameters": imageParameters
                  });
                  map.addLayer(dynamicMapServiceLayerbmt);
              }

          });
    </script>

    <!--  Date Picker-->
    <link rel="stylesheet" href="http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.6/themes/base/jquery-ui.css" type="text/css" media="all" />
    <script src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.9/jquery-ui.min.js"></script>
    <%--<script>
        jq189 = jQuery.noConflict(true);
    </script>--%>

    <script>
        //function BindCalender() {
        //    jq189(document).ready(function () {
        //        jq189("#txtFromDt").datepicker({
        //            dateFormat: 'dd-M-y',
        //            showOn: "button",
        //            buttonImage: "resource_gallery/graphics/calendar.gif",
        //            buttonImageOnly: true
        //        });
        //        jq189("#txtToDt").datepicker({
        //            dateFormat: 'dd-M-y',
        //            showOn: "button",
        //            buttonImage: "resource_gallery/graphics/calendar.gif",
        //            buttonImageOnly: true
        //        });
        //        jq189("#txtInspDueDt").datepicker({
        //            dateFormat: 'dd-M-y',
        //            showOn: "button",
        //            buttonImage: "resource_gallery/graphics/calendar.gif",
        //            buttonImageOnly: true
        //        });
        //    });
        //}

        //function CheckDateChanged() {
        //    if (document.getElementById("chkDate").checked == true) {
        //    }
        //    else {
        //        document.getElementById('txtFromDt').value = "";
        //        document.getElementById('txtToDt').value = "";
        //    }
        //}
    </script>
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server" EnablePageMethods="true"></asp:ScriptManager>
        <div>
            <!-- Navigation -->
            <nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top1">
                <div class="container-fluid" style="padding: 0!important;">


                    <div class="col-lg-4">

                        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
                            <span class="navbar-toggler-icon"></span>
                        </button>
                    </div>
                    <div class="col-lg-8">
                        <div class="collapse navbar-collapse" id="navbarResponsive">
                            <div class="col-sm-3">
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <asp:DropDownList ID="ddlInspSubType" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlInspSubType_SelectedIndexChanged" class="form-control">
                                        <asp:ListItem Text="Select Inspection Group.." Value="0"></asp:ListItem>
                                    </asp:DropDownList>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <asp:DropDownList ID="ddlIssueStatus" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlIssueStatus_SelectedIndexChanged" OnDataBound="ddlIssueStatus_DataBound" class="form-control">
                                        <asp:ListItem Text="Select Issue Status.." Value="0"></asp:ListItem>
                                    </asp:DropDownList>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <asp:DropDownList ID="ddlFlight" runat="server" OnSelectedIndexChanged="ddlFlight_SelectedIndexChanged" CssClass="form-control">
                                        <asp:ListItem Text="Select Flight Id.." Value="0"></asp:ListItem>
                                    </asp:DropDownList>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>

            <!-- Page Content -->
            <div>
                <div class="row">
                    <div class="col-lg-4 bgcolr">
                        <div class="row">
                            <div class="col-md-12 font-weight-bold left-header">
                                <img id="img-back" src="resource_gallery/graphics/arrow-back.png" alt="" style="display: none;" /><span id="span-header"></span>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">&nbsp;</div>
                        </div>

                        <div id="div-menu" class="row">
                            <div class="col-md-12">
                                <ul class="list-group">
                                    <li class="list-group-item"><span class="t">Layer Cotrols</span></li>
                                    <li class="list-group-item"><span class="t">Filter</span></li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center"><span class="t">Search Result</span><span class="badge badge-primary badge-pill">2</span></li>
                                    <li class="list-group-item"><span class="t">Details</span></li>
                                    <li class="list-group-item"><span class="t">Assign</span></li>
                                    <li class="list-group-item"><span class="t">Status</span></li>
                                </ul>
                            </div>
                        </div>

                        <!-- Accordion START -->
                        <div id="div-accordion" class="row" style="display: none;">
                            <div class="col-md-12">
                                <div class="panel-group" id="accordion">
                                    <div class="panel panel-default">
                                        <div class="panel-heading accordion-toggle collapsed" data-toggle="collapse" data-parent="#accordion" data-target="#collapseOne">
                                            <h4 class="panel-title">Trim Layers</h4>

                                        </div>
                                        <div id="collapseOne" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <div class="row">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input type="checkbox" value="">PunchList</label>
                                                        <img src="resource_gallery/Images/PunchList.png" />
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input type="checkbox" value="">Poles</label>
                                                        <img src="resource_gallery/Images/Poles.png" />
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input type="checkbox" value="">TreeRemovals</label>
                                                        <img src="resource_gallery/Images/Tree.png" />
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input type="checkbox" value="">BillType</label>
                                                        <img src="resource_gallery/Images/BillType.png" />
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input type="checkbox" value="">Row</label>
                                                        <img src="resource_gallery/Images/Row.png" />
                                                        <img src="resource_gallery/Images/Row.png" />
                                                        <img src="resource_gallery/Images/Row.png" />
                                                        <img src="resource_gallery/Images/Row.png" />
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="checkbox">
                                                        <label>
                                                        <input type="checkbox" value=""/>Trimming</label>
                                                        <img src="resource_gallery/Images/Trimming.png" />
                                                        <img src="resource_gallery/Images/Trimming2.png" />
                                                        <img src="resource_gallery/Images/Trimming3.png" />
                                                        <img src="resource_gallery/Images/Trimming4.png" />
                                                        <img src="resource_gallery/Images/Trimming5.png" />

                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input type="checkbox" value=""/>Climbing</label>
                                                        <img src="resource_gallery/Images/Climbing.png" />
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input type="checkbox" value=""/>Skipped</label>
                                                        <img src="resource_gallery/Images/Skipped.png" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading accordion-toggle collapsed" data-toggle="collapse" data-parent="#accordion" data-target="#collapseTwo">
                                            <h4 class="panel-title">Structure</h4>

                                        </div>
                                        <div id="collapseTwo" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <div class="row">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input type="checkbox" value=""/>Poles</label>
                                                        <img src="resource_gallery/Images/Poles1.png" />
                                                        <img src="resource_gallery/Images/Poles2.png" />
                                                        <img src="resource_gallery/Images/Poles3.png" />
                                                        <img src="resource_gallery/Images/Poles4.png" />
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input type="checkbox" value=""/>Substation</label>
                                                        <img src="resource_gallery/Images/substation1.png" />
                                                        <img src="resource_gallery/Images/Substation2.png" />
                                                        <img src="resource_gallery/Images/Substation3.png" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading accordion-toggle collapsed" data-toggle="collapse" data-parent="#accordion" data-target="#collapseFive">
                                            <h4 class="panel-title">Switchable and Protective Devices</h4>

                                        </div>
                                        <div id="collapseFive" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>
                                                    Bla bla bla 5 bla
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading accordion-toggle collapsed" data-toggle="collapse" data-parent="#accordion" data-target="#collapseThree">
                                            <h4 class="panel-title">Transformers</h4>

                                        </div>
                                        <div id="collapseThree" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>
                                                    Bla bla bla 3 bla
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading accordion-toggle collapsed" data-toggle="collapse" data-parent="#accordion" data-target="#collapseFour">
                                            <h4 class="panel-title">Miscelaneous Devices</h4>

                                        </div>
                                        <div id="collapseFour" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>
                                                    Bla bla bla bla bla
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading accordion-toggle collapsed" data-toggle="collapse" data-parent="#accordion" data-target="#collapseFour">
                                            <h4 class="panel-title">Primary & Busbar</h4>

                                        </div>
                                        <div id="collapsFive" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>
                                                    Bla bla bla bla bla
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel panel-default">
                                        <div class="panel-heading accordion-toggle collapsed" data-toggle="collapse" data-parent="#accordion" data-target="#collapseFour">
                                            <h4 class="panel-title">Parcel</h4>

                                        </div>
                                        <div id="collapsSix" class="panel-collapse collapse">
                                            <div class="panel-body">
                                                <p>
                                                    Bla bla bla bla bla
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <!-- Accordion END -->

                        <%-- Filter Start--%>
                        <div id="div-filter" class="bg-div" style="display: none;">
                            <div class="row">
                                <div class="col-12">
                                    &nbsp;
                                   <%--<script type="text/javascript">
                                       Sys.Application.add_load(BindCalender);
                                   </script>--%>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label for="ddlLineId" class="font-weight-bold text-black">Line Name</label>
                                    </div>
                                </div>
                                <div class="col-lg-8">
                                    <div class="form-group">
                                        <asp:DropDownList ID="ddlLineId" runat="server" OnSelectedIndexChanged="ddlLineId_SelectedIndexChanged" class="form-control">
                                        </asp:DropDownList>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label for="ddlEventCode" class="font-weight-bold text-black">Event Code</label>
                                    </div>
                                </div>
                                <div class="col-lg-8">
                                    <div class="form-group">
                                        <asp:DropDownList ID="ddlEventCode" runat="server" class="form-control"></asp:DropDownList>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label for="ddlIssueType" class="font-weight-bold text-black">Issue Type</label>
                                    </div>
                                </div>
                                <div class="col-lg-8">
                                    <div class="form-group">
                                        <asp:DropDownList ID="ddlIssueType" runat="server" class="form-control" AutoPostBack="true" OnSelectedIndexChanged="ddlIssueType_SelectedIndexChanged"></asp:DropDownList>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label for="ddlIssueSubType" class="font-weight-bold text-black">Issue SubType</label>
                                    </div>
                                </div>
                                <div class="col-lg-8">
                                    <div class="form-group">
                                        <asp:DropDownList ID="ddlIssueSubType" runat="server" class="form-control"></asp:DropDownList>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label for="txtFromDt" class="font-weight-bold text-black">From Date</label>
                                    </div>
                                </div>
                                <div class="col-lg-8">
                                    <div class="form-group">
                                        <asp:TextBox ID="txtFromDt" runat="server" class="form-control"></asp:TextBox>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label for="txtToDt" class="font-weight-bold text-black">To Date</label>
                                    </div>
                                </div>
                                <div class="col-lg-8">
                                    <div class="form-group">
                                        <asp:TextBox ID="txtToDt" runat="server" class="form-control"></asp:TextBox>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        &nbsp;
                                    </div>
                                </div>
                                <div class="col-lg-8">
                                    <div class="form-group">
                                        <button class="btn btn-primary" type="submit">Search</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <%-- Filter end--%>

                        <%--Search Result Start--%>
                        <div id="div-result" class="bg-div" style="display: none; min-height: 100px;">
                            <div class="row">
                                <div class="col-12">
                                    <asp:GridView ID="gdv_list" runat="server" AutoGenerateColumns="false" ShowHeader="false" OnRowDataBound="gdv_list_RowDataBound" Width="100%">
                                        <Columns>
                                            <asp:BoundField DataField="sequencer" HeaderText="sequencer" ItemStyle-CssClass="hiddencol" />
                                            <asp:BoundField DataField="Idesc" HeaderText="Idesc" />
                                            <asp:BoundField DataField="X" HeaderText="X" ItemStyle-CssClass="hiddencol" />
                                            <asp:BoundField DataField="Y" HeaderText="Y" ItemStyle-CssClass="hiddencol" />
                                        </Columns>
                                    </asp:GridView>
                                </div>
                            </div>
                        </div>
                        <%--Search Result End--%>

                        <%-- Details Start--%>
                        <div id="div-details" class="bg-div" style="display: none;">
                            <div class="row">
                                <div class="col-12">&nbsp;</div>
                            </div>
                            <div class='row'>
                                <div class='col-xs-6'>
                                    <label class='control-label'>SCE&G Note:</label>
                                </div>
                                <div class='col-xs-6'>
                                    <asp:Label ID="lblSCEGNote" runat="server"></asp:Label>
                                </div>
                            </div>
                            <div class='row'>
                                <div class='col-xs-6'>
                                    <label class='control-label'>Flag ID:</label>
                                </div>
                                <div class='col-xs-6'>
                                    <asp:Label ID="lblFlagID" runat="server"></asp:Label>
                                </div>
                            </div>
                            <div class='row'>
                                <div class='col-xs-6'>
                                    <label class='control-label'>Contractor:</label>
                                </div>
                                <div class='col-xs-6'>
                                    <asp:Label ID="lblContractor" runat="server"></asp:Label>
                                </div>
                            </div>
                            <div class='row'>
                                <div class='col-xs-6'>
                                    <label class='control-label'>Contractor Note:</label>
                                </div>
                                <div class='col-xs-6'>
                                    <asp:Label ID="lblContractorNote" runat="server"></asp:Label>
                                </div>
                            </div>
                            <div class='row'>
                                <div class='col-xs-6'>
                                    <label class='control-label'>Assigned To:</label>
                                </div>
                                <div class='col-xs-6'>
                                    <asp:Label ID="lblAssignedTo" runat="server"></asp:Label>
                                </div>
                            </div>
                            <div class='row'>
                                <div class='col-xs-6'>
                                    <label class='control-label'>Assigned Date:</label>
                                </div>
                                <div class='col-xs-6'>
                                    <asp:Label ID="lblAssignedDate" runat="server"></asp:Label>
                                </div>
                            </div>
                            <div class='row'>
                                <div class='col-xs-6'>
                                    <label class='control-label'>Tree Count:</label>
                                </div>
                                <div class='col-xs-6'>
                                    <asp:Label ID="lblTreeCnt" runat="server"></asp:Label>
                                </div>
                            </div>
                            <div class='row'>
                                <div class='col-xs-6'>
                                    <label class='control-label'>Last Updated By:</label>
                                </div>
                                <div class='col-xs-6'>
                                    <asp:Label ID="lblLastUpdatedBy" runat="server"></asp:Label>
                                </div>
                            </div>
                            <div class='row'>
                                <div class='col-xs-6'>
                                    <label class='control-label'>Last Updated On:</label>
                                </div>
                                <div class='col-xs-6'>
                                    <asp:Label ID="lblLastUpdatedOn" runat="server"></asp:Label>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">&nbsp;</div>
                            </div>
                        </div>
                        <%-- Details End--%>

                        <%-- Assign Start--%>
                        <div id="div-assign" class="bg-div" style="display: none;">
                            <div class="row">
                                <div class="col-12">&nbsp;</div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <asp:UpdatePanel ID="UpdatePanel6" runat="server" UpdateMode="Conditional">
                                        <ContentTemplate>
                                            <asp:RadioButtonList ID="rblAssign" runat="server" RepeatDirection="Horizontal" AutoPostBack="true" OnSelectedIndexChanged="rblAssign_SelectedIndexChanged">
                                                <asp:ListItem Text="All" Value="0"></asp:ListItem>
                                                <asp:ListItem Text="Selected" Value="1" Selected="True"></asp:ListItem>
                                            </asp:RadioButtonList>
                                        </ContentTemplate>
                                    </asp:UpdatePanel>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label for="ddlLineId" class="font-weight-bold text-black">Company:</label>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <asp:UpdatePanel ID="UpdatePanel5" runat="server">
                                            <ContentTemplate>
                                                <asp:DropDownList ID="ddlAssignedTo" Width="100" runat="server" AutoPostBack="true"></asp:DropDownList>
                                            </ContentTemplate>
                                        </asp:UpdatePanel>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label for="ddlLineId" class="font-weight-bold text-black">Current Crew:</label>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <asp:Label ID="lblCrew" runat="server"></asp:Label>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label for="ddlLineId" class="font-weight-bold text-black">Updated Crew:</label>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <asp:UpdatePanel ID="UpdatePanel3" runat="server">
                                            <ContentTemplate>
                                                <asp:DropDownList ID="ddlCrew" Width="100" runat="server"></asp:DropDownList>
                                            </ContentTemplate>
                                        </asp:UpdatePanel>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label for="ddlLineId" class="font-weight-bold text-black">Inspection Due Dt:</label>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <asp:TextBox ID="txtInspDueDt" Width="100" runat="server"></asp:TextBox>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        &nbsp;
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <asp:UpdatePanel ID="UpdatePanel7" runat="server" ChildrenAsTriggers="true" UpdateMode="Conditional">
                                            <ContentTemplate>
                                                <asp:Button ID="btnReset" runat="server" Text="Reset" CssClass="btn btn-primary" OnClick="btnReset_Click" />
                                                <asp:Button ID="btnAssign" runat="server" Text="Assign" CssClass="btn btn-primary" OnClientClick="return ConfirmAssignMessage();" OnClick="btnAssign_Click" />
                                            </ContentTemplate>
                                            <Triggers>
                                                <asp:AsyncPostBackTrigger ControlID="btnAssign" EventName="Click" />
                                            </Triggers>
                                        </asp:UpdatePanel>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <%-- Assign End--%>

                        <%-- Status Start--%>
                        <div id="div-status" class="bg-div" style="display: none;">
                            <div class="row">
                                <div class="col-12">&nbsp;</div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <asp:RadioButtonList ID="rblStatus" runat="server" RepeatDirection="Horizontal" AutoPostBack="true" OnSelectedIndexChanged="rblStatus_SelectedIndexChanged">
                                        <asp:ListItem Text="All" Value="0"></asp:ListItem>
                                        <asp:ListItem Text="Selected" Value="1" Selected="True"></asp:ListItem>
                                    </asp:RadioButtonList>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label for="ddlLineId" class="font-weight-bold text-black">Current Status:</label>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <asp:Label ID="lblCurrentStatus" runat="server" Text=""></asp:Label>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label for="ddlLineId" class="font-weight-bold text-black">Update Status:</label>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <asp:DropDownList ID="ddlUpdatedStatus" Width="150px" runat="server"></asp:DropDownList>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        &nbsp;
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <asp:Button ID="btnStatusReset" runat="server" Text="Reset" CssClass="btn btn-primary" OnClick="btnStatusReset_Click" />
                                        <asp:Button ID="btnUpdate" runat="server" Text="Update" CssClass="btn btn-primary" OnClientClick="return ConfirmStatusMessage();" OnClick="btnUpdate_Click" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <%-- Status End--%>
                    </div>
                    <!-- /.col-lg-3 -->

                    <div class="col-lg-8">
                        <div id="map" style="height: 92vh; width: 100%!important; margin-right: 0px;">
                        </div>


                    </div>
                    <!-- /.col-lg-9 -->

                </div>

            </div>
            <!-- /.container -->

            <!-- Footer -->
            <%--<footer class="py-5 bg-dark">
            <div class="container">
                <p class="m-0 text-center text-white">Copyright &copy; Your Website 2017</p>
            </div>
            <!-- /.container -->
        </footer>--%>
        </div>

    </form>
</body>
</html>
