﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;

namespace VMT
{
    public partial class Spray_WA_Rates_Company : System.Web.UI.Page
    {
        string m_SP_SPRWRA_SEL_BU = Properties.Settings.Default.SP_SPRWRA_SEL_BU;
        string m_SP_SPRWRA_YEAR = Properties.Settings.Default.SP_SPRWRA_YEAR;
        string m_SP_SPRWRA_SEL_COMPANY = Properties.Settings.Default.SP_SPRWRA_SEL_COMPANY;
        string m_SP_SPRWRA_SEL_WORKAREA = Properties.Settings.Default.SP_SPRWRA_SEL_WORKAREA;
        string m_SP_SPRWRA_SEL_RATETYPE = Properties.Settings.Default.SP_SPRWRA_SEL_RATETYPE;
        string m_SP_SPRWRA_SEL_RATES_COMPANY_WA = Properties.Settings.Default.SP_SPRWRA_SEL_RATES_COMPANY_WA;
        string m_SP_SPRWRA_SEL_RATETYPE_DETAIL = Properties.Settings.Default.SP_SPRWRA_SEL_RATETYPE_DETAIL;
        string m_SP_SPRWRA_RATES_WA_CMP_INS_DEL = Properties.Settings.Default.SP_SPRWRA_RATES_WA_CMP_INS_DEL;
        string m_SP_SPRWRA_SEL_EVENTCODE = Properties.Settings.Default.SP_SPRWRA_SEL_EVENTCODE;
        string m_SP_SPRWRA_SEL_WA_GRID = Properties.Settings.Default.SP_SPRWRA_SEL_WA_GRID;
        string BU = "";
        string EC = "";
        string YR = "";
        string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {

            //checks user role
            userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            if (userRole == "Edit")
            {
                rowAdd.Visible = true;
                rowAddBtn.Visible = true;
            }
            else
            {
                rowAdd.Visible = false;
                rowAddBtn.Visible = false;
            }


            if (!Page.IsPostBack)
            {
                bindBusinessUnit();
                if (Request.QueryString["BU"] != null)
                {
                    BU = Request.QueryString["BU"].Trim();
                }
                if (Request.QueryString["EC"] != null)
                {
                    EC = Request.QueryString["EC"].Trim();
                }
                if (Request.QueryString["YR"] != null)
                {
                    YR = Request.QueryString["YR"].Trim();
                }

                if (BU == "")
                {

                    ddl_Bunit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                    bindYear();
                }
                else
                {
                    ddl_Bunit.SelectedValue = BU;
                    bindYear();

                }


                if (YR == "")
                {
                    //ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                    bindEventCode();
                }
                else
                {
                    ddl_Year.SelectedValue = YR;
                    bindEventCode();
                }
                if (EC != "")
                {
                    ddl_EventCode.SelectedValue = EC;
                    bindCompany();
                    // bindGrid();
                }
                CreateNew.Visible = false;
            }
        }
        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPRWRA_SEL_BU, ddl_Bunit);
            }
            catch
            {
            }
        }
        void bindYear()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_Bunit.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRWRA_YEAR, OledbParams, ddl_Year);
            }
            catch
            {
            }
        }

        void bindWorkAreas()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_Bunit.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", ddl_Year.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", ddl_Company.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", ddl_EventCode.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRWRA_SEL_WORKAREA, OledbParams, ddl_WorkArea);
            }
            catch
            {
            }
        }

        void bindGridWorkAreas()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_Bunit.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", ddl_Year.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", ddl_Company.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", ddl_EventCode.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", ddl_WorkArea.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRWRA_SEL_WA_GRID, OledbParams, ddl_gridWorkArea);
            }
            catch
            {
            }
        }
        void bindCompany()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_Bunit.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", ddl_Year.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", ddl_EventCode.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRWRA_SEL_COMPANY, OledbParams, ddl_Company);
            }
            catch
            {
            }
        }
        void bindEventCode()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_Bunit.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", ddl_Year.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRWRA_SEL_EVENTCODE, OledbParams, ddl_EventCode);
            }
            catch
            {
            }
        }
        public int intnull(string inttext)
        {
            int value1 = 0;
            try
            {
                value1 = Convert.ToInt32(inttext);
            }
            catch (Exception ex)
            {
                value1 = 0;
            }
            return value1;
        }
        void bindrateType()
        {

            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_COMPANY_ID = 0;
            int V_WORK_AREA_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);
                V_WORK_AREA_ID = intnull(ddl_gridWorkArea.SelectedValue);
                V_EVENT_CODE_ID = intnull(ddl_EventCode.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRWRA_SEL_RATETYPE, OledbParams, ddl_RateTypes);
            }
            catch
            {
            }
        }
        private void bindGrid()
        {

            int V_WORK_AREA_ID = 0;
            int V_YEAR = 0;
            int V_COMPANY_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_WORK_AREA_ID = Convert.ToInt32(ddl_WorkArea.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddl_EventCode.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();

                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SPRWRA_SEL_RATES_COMPANY_WA, OledbParams, gdv_Rate_Company);
            }
            catch
            {
            }
        }
        void getUOM()
        {
            try
            {
                if (ddl_RateTypes.SelectedIndex >= 0)
                {
                    DataSet ds = new DataSet();
                    List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                    OleDbParams.Add(new OleDbParameter("V_RATE_TYPE_ID", ddl_RateTypes.SelectedValue));
                    ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SPRWRA_SEL_RATETYPE_DETAIL, OleDbParams);

                    //bind the fields 

                    lbl_UOM.Text = ds.Tables[0].Rows[0]["UOM"].ToString();
                }
                else
                {
                    lbl_UOM.Text = "";
                }
            }
            catch
            {
            }
        }
        private void AddDelete(string strOperation, int V_RATE_YEAR_ID, int V_RATE_TYPE_ID, int V_COMPANY_ID, int V_EVENT_CODE_ID, int V_WORK_AREA_ID, double V_RATE_TYPE_AMOUNT)
        {
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_RATE_YEAR_ID", V_RATE_YEAR_ID));
                sqlParams.Add(new OleDbParameter("V_RATE_TYPE_ID", V_RATE_TYPE_ID));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                sqlParams.Add(new OleDbParameter("V_RATE_TYPE_AMOUNT", V_RATE_TYPE_AMOUNT));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPRWRA_RATES_WA_CMP_INS_DEL, sqlParams);


            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {


                //   ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                //  ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " failed.')", true);
            }

        }


        void resetControl()
        {
            txt_Rateamount.Text = "";


        }
        protected void ddl_Bunit_DataBound(object sender, EventArgs e)
        {
            bindYear();
        }

        protected void btn_addRates_Click(object sender, EventArgs e)
        {

            if (txt_Rateamount.Text.Trim() == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate Amount could not be blank!')", true);
                txt_Rateamount.Focus();
                return;
            }

            if (ddl_RateTypes.SelectedIndex < 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select Rate Type!')", true);
                ddl_RateTypes.Focus();
                return;
            }
            double V_RATE_TYPE_AMOUNT = 0.0;
            try
            {
                V_RATE_TYPE_AMOUNT = Convert.ToDouble(txt_Rateamount.Text.Trim());
            }
            catch (Exception ex)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate Amount could not be non-Numeric!')", true);
                txt_Rateamount.Focus();
                return;
            }

            string strOperation = "";
            int V_RATE_YEAR_ID = 0;
            int V_RATE_TYPE_ID = 0;
            int V_COMPANY_ID = 0;
            int V_EVENT_CODE_ID = 0;
            int V_WORK_AREA_ID = 0;

            try
            {
                strOperation = "INSERT";
                V_RATE_YEAR_ID = Convert.ToInt32(ddl_Year.SelectedValue);
                V_RATE_TYPE_ID = Convert.ToInt32(ddl_RateTypes.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddl_EventCode.SelectedValue);
                V_WORK_AREA_ID = Convert.ToInt32(ddl_gridWorkArea.SelectedValue);



                AddDelete(strOperation, V_RATE_YEAR_ID, V_RATE_TYPE_ID, V_COMPANY_ID, V_EVENT_CODE_ID, V_WORK_AREA_ID, V_RATE_TYPE_AMOUNT);
                bindGrid();
                bindGridWorkAreas();
                bindrateType();
                resetControl();
            }
            catch
            {
            }
        }

        protected void ddl_Year_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindEventCode();
        }

        protected void ddl_Year_DataBound(object sender, EventArgs e)
        {
            //if (!Page.IsPostBack)
            //{
            //    ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
            //}
            bindEventCode();
        }

        protected void ddl_Company_DataBound(object sender, EventArgs e)
        {

            bindWorkAreas();
        }

        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindYear();
        }

        protected void ddl_Company_SelectedIndexChanged(object sender, EventArgs e)
        {

            bindWorkAreas();
        }

        protected void btnshowhide_Click(object sender, ImageClickEventArgs e)
        {
            if (CreateNew.Visible == true)
            {
                CreateNew.Visible = false;
                btnshowhide.ImageUrl = "resource_gallery/graphics/plus.png";
            }
            else
            {
                btnshowhide.ImageUrl = "resource_gallery/graphics/minus.png";
                CreateNew.Visible = true;
            }
        }

        protected void ddl_WorkArea_DataBound(object sender, EventArgs e)
        {
            bindGridWorkAreas();
            // bindrateType();
            bindGrid();
        }

        protected void ddl_RateTypes_SelectedIndexChanged(object sender, EventArgs e)
        {
            getUOM();
        }

        protected void ddl_RateTypes_DataBound(object sender, EventArgs e)
        {
            getUOM();
        }

        protected void gdv_Rate_Company_RowCreated(object sender, GridViewRowEventArgs e)
        {

            e.Row.Cells[5].Visible = false;
            e.Row.Cells[6].Visible = false;
            e.Row.Cells[7].Visible = false;
            e.Row.Cells[8].Visible = false;
            e.Row.Cells[9].Visible = false;
            //checks user role
            userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            if (userRole == "Edit")
            {
                e.Row.Cells[4].Visible = true;
            }
            else
            {
                e.Row.Cells[4].Visible = false;
            }
        }

        protected void ddl_WorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindGridWorkAreas();
            //bindrateType();
            bindGrid();
        }

        protected void gdv_Rate_Company_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            try
            {
                GridViewRow row = (GridViewRow)gdv_Rate_Company.Rows[e.RowIndex];

                int V_RATE_YEAR_ID = Convert.ToInt32((row.FindControl("lbl_RATE_YEAR_ID") as Label).Text);
                int V_RATE_TYPE_ID = Convert.ToInt32((row.FindControl("lbl_RATE_TYPE_ID") as Label).Text);
                int V_COMPANY_ID = Convert.ToInt32((row.FindControl("lbl_COMPANY_ID") as Label).Text);
                int V_EVENT_CODE_ID = Convert.ToInt32((row.FindControl("lbl_EVENT_CODE_ID") as Label).Text);
                int V_WORK_AREA_ID = Convert.ToInt32((row.FindControl("lbl_WORK_AREA_ID") as Label).Text);

                double V_RATE_TYPE_AMOUNT = 0.0;
                AddDelete("DELETE", V_RATE_YEAR_ID, V_RATE_TYPE_ID, V_COMPANY_ID, V_EVENT_CODE_ID, V_WORK_AREA_ID, V_RATE_TYPE_AMOUNT);

                bindGrid();
                bindrateType();
                resetControl();
            }
            catch
            {
            }
        }

        protected void ddl_EventCode_DataBound(object sender, EventArgs e)
        {
            bindCompany();
            // bindWorkAreas();
        }

        protected void ddl_EventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindCompany();
            // bindWorkAreas();
        }

        protected void ddl_gridWorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindrateType();
        }

        protected void ddl_gridWorkArea_DataBound(object sender, EventArgs e)
        {
            bindrateType();
        }
    }
}