﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;
using System.IO;

namespace VMT
{
    public partial class SprayProjectInspectors : System.Web.UI.Page
    {
        string m_SP_SPR_PI_SELECT_BU = Properties.Settings.Default.SP_SPR_PI_SELECT_BU;
        string m_SP_SPR_PI_SELECT_EV = Properties.Settings.Default.SP_SPR_PI_SELECT_EV;
        string m_SP_SPR_PI_SELECT_COMPANY = Properties.Settings.Default.SP_SPR_PI_SELECT_COMPANY;
        string m_SP_SPR_PI_SELECT_COMPANY_EMP = Properties.Settings.Default.SP_SPR_PI_SELECT_COMPANY_EMP;
        string m_SP_SPR_PI_SELECT_EV_L = Properties.Settings.Default.SP_SPR_PI_SELECT_EV_L;
        string m_SP_SPR_PI_SELECT_CMP_EMP_L = Properties.Settings.Default.SP_SPR_PI_SELECT_CMP_EMP_L;
        string m_SP_SPR_PI_INSPECTOR_INS_DEL = Properties.Settings.Default.SP_SPR_PI_INSPECTOR_INS_DEL;
        string m_SP_SPR_PI_SELECT_EV_INSPECTOR = Properties.Settings.Default.SP_SPR_PI_SELECT_EV_INSPECTOR;

        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Assign Inspector to Spray Project/Event";

        protected void Page_Load(object sender, EventArgs e)
        {
           
            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            //if (userRole == "Edit")
            //{
            //    btn_add1.Visible = true;
            //    // btnGo.Visible = true;
            //    btn_expExcel.Visible = true;
            //}
            //else
            //{
            //    btn_add1.Visible = false;
            //    //  btnGo.Visible = false;
            //    btn_expExcel.Visible = false;
            //}

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btn_expExcel);
            if (!Page.IsPostBack)
            {


                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }
                hdn_role.Value = userRole;
                btn_expExcel.Visible = false;
                bindBusinessUnit();
                bindCompany();

                //   bindListEventCode();
                //   bindListEmployees();

                //if (Request.QueryString.ToString().Length > 0)
                //{
                //    ddl_Bunit.SelectedValue = Request.QueryString["BU"];
                //    bindYear();
                //}
                //else
                //{
                //    ddl_Bunit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                //    bindYear();
                //}

                //if (Request.QueryString.ToString().Length > 0)
                //{
                //    ddl_Year.SelectedValue = Request.QueryString["YR"];
                //    bindEventCode();
                //}

                //if (Request.QueryString.ToString().Length > 0)
                //{
                //    ddl_eventcode.SelectedValue = Request.QueryString["EC"];
                //    bindWorkAreas();
                //    bindGrid();
                //}

            }
        }

        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPR_PI_SELECT_BU, ddl_Bunit);
            }
            catch
            {
            }
        }
        void bindCompany()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPR_PI_SELECT_COMPANY, ddl_Company);

            }
            catch
            {
            }
        }
        void bindEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_PI_SELECT_EV, OledbParams, ddl_eventcode);
            }
            catch
            {
            }
        }
        void bindEmployee()
        {
            ddl_Company.SelectedValue = Properties.Settings.Default.DEFAULT_COMPANY_INSPECTOR;
            ddl_Company.Enabled = false;
            int V_COMPANY_ID = 0;
            try
            {
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Convert.ToInt32(ddl_Bunit.SelectedValue)));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", Convert.ToInt32(ddl_eventcode.SelectedValue)));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_PI_SELECT_COMPANY_EMP, OledbParams, ddl_Employee);

            }
            catch
            {
            }
        }
        void bindListEventCode()
        {
            try
            {
                if (ddl_eventcode.SelectedIndex >= 0)
                {
                    lst_selWorkArea.Items.Clear();
                    List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                    OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Convert.ToInt32(ddl_Bunit.SelectedValue)));
                    DataAccessUtility.BindListboxWithConditionViaProcedure(m_SP_SPR_PI_SELECT_EV_L, OledbParams, lst_WorkArea);
                }
                else
                {
                    lst_WorkArea.Items.Clear();
                    lst_selWorkArea.Items.Clear();
                }
            }
            catch
            {
            }
        }
        void bindListEmployees()
        {
            try
            {
                if (ddl_Company.SelectedIndex >= 0)
                {
                    lst_selWorkArea.Items.Clear();
                    List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                    OledbParams.Add(new OleDbParameter("V_COMPANY_ID", Convert.ToInt32(ddl_Company.SelectedValue)));

                    DataAccessUtility.BindListboxWithConditionViaProcedure(m_SP_SPR_PI_SELECT_CMP_EMP_L, OledbParams, lst_Employee);
                }
                else
                {
                    lst_Employee.Items.Clear();
                    lst_selEmployee.Items.Clear();
                }
            }
            catch
            {
            }
        }

        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindEventCode();
            bindListEventCode();
        }

        protected void ddl_Bunit_DataBound(object sender, EventArgs e)
        {
            bindEventCode();
            bindListEventCode();
        }

        protected void ddl_eventcode_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindEmployee();
        }

        protected void ddl_eventcode_DataBound(object sender, EventArgs e)
        {
            bindEmployee();
        }



        protected void gdv_EC_CompEmp_RowCreated(object sender, GridViewRowEventArgs e)
        {

            e.Row.Cells[5].Visible = false;
            e.Row.Cells[6].Visible = false;
            e.Row.Cells[7].Visible = false;
            //checks user role
           // userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            if (hdn_role.Value == "3")
            {
                e.Row.Cells[4].Visible = true;
            }
            else
            {
                e.Row.Cells[4].Visible = false;
            }
        }

        protected void btn_addWA_Click(object sender, EventArgs e)
        {
            try
            {
                if (lst_WorkArea.SelectedValue.ToString().Trim() != "0")
                {
                    foreach (ListItem item in this.lst_WorkArea.Items)
                    {
                        if (item.Selected)
                        {
                            this.lst_selWorkArea.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }


                    for (int i = lst_WorkArea.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_WorkArea.Items[i].Selected)
                        {
                            lst_WorkArea.Items.RemoveAt(i);
                        }

                    }

                }
                else
                {
                    foreach (ListItem item in this.lst_WorkArea.Items)
                    {
                        if (item.Value.ToString().Trim() != "0")
                        {
                            this.lst_selWorkArea.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }

                    for (int i = lst_WorkArea.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_WorkArea.Items[i].Value.ToString() != "0")
                        {
                            lst_WorkArea.Items.RemoveAt(i);
                        }

                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_remWA_Click(object sender, EventArgs e)
        {
            try
            {
                foreach (ListItem item in this.lst_selWorkArea.Items)
                {
                    if (item.Selected)
                    {
                        this.lst_WorkArea.Items.Add(new ListItem(item.Text, item.Value));
                    }
                }


                for (int i = lst_selWorkArea.Items.Count - 1; i >= 0; i--)
                {
                    if (lst_selWorkArea.Items[i].Selected)
                    {
                        lst_selWorkArea.Items.RemoveAt(i);
                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_addEmp_Click(object sender, EventArgs e)
        {
            try
            {
                if (lst_Employee.SelectedValue.ToString().Trim() != "0")
                {
                    foreach (ListItem item in this.lst_Employee.Items)
                    {
                        if (item.Selected)
                        {
                            this.lst_selEmployee.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }

                    for (int i = lst_Employee.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_Employee.Items[i].Selected)
                        {
                            lst_Employee.Items.RemoveAt(i);
                        }

                    }

                }
                else
                {
                    foreach (ListItem item in this.lst_Employee.Items)
                    {
                        if (item.Value.ToString().Trim() != "0")
                        {
                            this.lst_selEmployee.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }

                    for (int i = lst_Employee.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_Employee.Items[i].Value.ToString() != "0")
                        {
                            lst_Employee.Items.RemoveAt(i);
                        }

                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_remEmp_Click(object sender, EventArgs e)
        {
            try
            {
                foreach (ListItem item in this.lst_selEmployee.Items)
                {
                    if (item.Selected)
                    {
                        this.lst_Employee.Items.Add(new ListItem(item.Text, item.Value));
                    }
                }

                for (int i = lst_selEmployee.Items.Count - 1; i >= 0; i--)
                {
                    if (lst_selEmployee.Items[i].Selected)
                    {
                        lst_selEmployee.Items.RemoveAt(i);
                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_add1_Click(object sender, EventArgs e)
        {
            try
            {
                if (lst_selWorkArea.Items.Count == 0)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('No Projevt/Event Selected!')", true);
                    return;
                }

                if (lst_selEmployee.Items.Count == 0)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('No Employee Selected!')", true);
                    return;
                }


                foreach (ListItem itemC in this.lst_selEmployee.Items)
                {

                    foreach (ListItem itemW in this.lst_selWorkArea.Items)
                    {
                        AddDelete("INSERT", Int32.Parse(ddl_Bunit.SelectedValue), Int32.Parse(itemW.Value), Int32.Parse(itemC.Value));

                    }

                }


                bindGrid();
                ResetControl();
            }
            catch
            {
            }
        }
        private void AddDelete(string strOperation, int V_BUSINESS_UNIT_ID, int V_EVENT_CODE_ID, int V_EMPLOYEE_ID)
        {
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                sqlParams.Add(new OleDbParameter("V_EMPLOYEE_ID", V_EMPLOYEE_ID));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPR_PI_INSPECTOR_INS_DEL, sqlParams);


            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {


                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Work_Area Company already exists')", true);
            }

        }

        private void bindGrid()
        {
            gdv_EC_CompEmp.DataBind();

            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();

                OleDbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Convert.ToInt32(ddl_Bunit.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", Convert.ToInt32(ddl_eventcode.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("V_EMPLOYEE_ID", Convert.ToInt32(ddl_Employee.SelectedValue)));



                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SPR_PI_SELECT_EV_INSPECTOR, OleDbParams, gdv_EC_CompEmp);
            }
            catch
            {
            }
        }
        private void ResetControl()
        {
            lst_selEmployee.Items.Clear();
            lst_selWorkArea.Items.Clear();

            bindListEventCode();
            bindListEmployees();

            if (gdv_EC_CompEmp.Rows.Count == 0)
            {
                btn_expExcel.Visible = false;
            }
            else
            {
                btn_expExcel.Visible = true;
            }
        }
        protected void gdv_EC_CompEmp_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            try
            {
                GridViewRow row = (GridViewRow)gdv_EC_CompEmp.Rows[e.RowIndex];
                int V_BUSINESS_UNIT_ID = Convert.ToInt32((row.FindControl("lbl_BUSINESS_UNIT_ID") as Label).Text);
                int V_EVENT_CODE_ID = Convert.ToInt32((row.FindControl("lbl_EVENT_CODE_ID") as Label).Text);
                int V_EMPLOYEE_ID = Convert.ToInt32((row.FindControl("lbl_EMPLOYEE_ID") as Label).Text);
                AddDelete("DELETE", V_BUSINESS_UNIT_ID, V_EVENT_CODE_ID, V_EMPLOYEE_ID);

                bindGrid();
            }
            catch
            {
            }
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }
        protected void btn_expExcel_Click(object sender, EventArgs e)
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddl_Bunit.SelectedItem.Text);
                dictionaryFilters.Add("Event/Project", ddl_eventcode.SelectedItem.Text);
                dictionaryFilters.Add("Employee", ddl_Employee.SelectedItem.Text);
                List<int> listColumnIndex = new List<int>(new int[] { 4 });
                VDMUtil.ExportGridToExcel(gdv_EC_CompEmp, "Spray Project-Inspector", "Spray Project-Inspector", dictionaryFilters, listColumnIndex);
            }
            catch
            {
            }
        }

        protected void ddl_Company_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindEmployee();
            bindListEmployees();
        }

        protected void ddl_Company_DataBound(object sender, EventArgs e)
        {
            bindEmployee();
            bindListEmployees();
        }

        protected void ddl_Employee_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        protected void ddl_Employee_DataBound(object sender, EventArgs e)
        {

        }

        protected void btnGo_Click(object sender, EventArgs e)
        {
            bindGrid();
        }







    }
}