﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.OleDb;
using System.Data;
using DataAccess;

namespace VMT
{
    public partial class SprayProjectCompletionStatus : System.Web.UI.Page
    {
        string m_SP_SPR_PROJ_COMP_BU = Properties.Settings.Default.SP_SPR_PROJ_COMP_BU;
        string m_SP_SPR_VDM_SELECT_YEAR_BU = Properties.Settings.Default.SP_SPR_VDM_SELECT_YEAR_BU;
        string m_SP_SPR_PROJ_COMP_EVENT_CODE = Properties.Settings.Default.SP_SPR_PROJ_COMP_EVENT_CODE;
        string m_SP_SPR_SEL_PRO_COMPL_STATUS = Properties.Settings.Default.SP_SPR_SEL_PRO_COMPL_STATUS;
        string m_SP_SPR_VDM_SELECT_WA_STATUS = Properties.Settings.Default.SP_SPR_VDM_SELECT_WA_STATUS;
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Spray Project Completion Report";

        protected void Page_Load(object sender, EventArgs e)
        {
           

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {
                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                BindBusinessUnit();
                ddlBUnit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                //BindYear();
                //ddlYear.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                //BindWorkAreaStatus();
                BindEventCode();
            }
        }

        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPR_PROJ_COMP_BU, ddlBUnit);
            }
            catch
            {
            }
        }

        //void BindYear()
        //{
        //    try
        //    {
        //        List<OleDbParameter> OledbParams = new List<OleDbParameter>();
        //        OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddlBUnit.SelectedValue));
        //        DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_VDM_SELECT_YEAR_BU, OledbParams, ddlYear);
        //    }
        //    catch
        //    {
        //    }
        //}
               

        //void BindWorkAreaStatus()
        //{
        //    int V_BUSINESS_UNIT_ID = 0;
        //    int V_YEAR = 0;
        //    try
        //    {
        //        V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
        //        V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);

        //        List<OleDbParameter> OledbParams = new List<OleDbParameter>();
        //        OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
        //        OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
        //        DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_VDM_SELECT_WA_STATUS, OledbParams, ddlBidStatus);
        //    }
        //    catch
        //    {
        //    }
        //}


        //protected void ddlBidStatus_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    BindEventCode();
        //}

        void BindEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
            //int V_YEAR = 0;
            //int V_STATUS = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                //V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);
                //V_STATUS = Convert.ToInt32(ddlBidStatus.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                //OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                //OledbParams.Add(new OleDbParameter("V_STATUS", V_STATUS));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_PROJ_COMP_EVENT_CODE, OledbParams, ddlEventCode);
            }
            catch
            {
            }

        }

        //protected void btnGo_Click(object sender, EventArgs e)
        //{
        //    BindBidGrid();
        //}

        void BindBidGrid()
        {
            int businessunit;
            //int year;
            //int status;
            int Evtcode;
            try
            {
                businessunit = Int32.Parse(ddlBUnit.SelectedValue.ToString());
                //year = Int32.Parse(ddlYear.SelectedValue.ToString());
                //status = Int32.Parse(ddlBidStatus.SelectedValue.ToString());
                //if (ddlEventCode.SelectedValue.Trim() == "")
                //    Evtcode = 0;
                //else
                Evtcode = Int32.Parse(ddlEventCode.SelectedValue.ToString());
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();

                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", businessunit));
                sqlParams.Add(new OleDbParameter("V_EVTCODE", Evtcode));
                //sqlParams.Add(new OleDbParameter("V_YEAR", year));
                //sqlParams.Add(new OleDbParameter("V_STATUS", status));

                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SPR_SEL_PRO_COMPL_STATUS, sqlParams, gdvWorkArea);
                ViewState["dataTable"] = gdvWorkArea.DataSource as DataSet;
                //fixed gridview header
                ScriptManager.RegisterStartupScript(Page, this.GetType(), "Key", "<script>MakeStaticHeader('" + gdvWorkArea.ClientID + "', 260, 850 , 40 ,false); </script>", false);

                if (gdvWorkArea.Rows.Count > 0)
                    btnExportExcel.Visible = true;
                else
                    btnExportExcel.Visible = false;

                
            }
            catch
            {
            }
        }

        protected void gdvWorkArea_Sorting(object sender, GridViewSortEventArgs e)
        {
            VDMUtil.GridviewSorting(gdvWorkArea, e.SortExpression, (DataSet)ViewState["dataTable"]);
        }

        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
            dictionaryFilters.Add("Business Unit", ddlBUnit.SelectedItem.Text);
            //dictionaryFilters.Add("Year", ddlYear.SelectedItem.Text);
            //dictionaryFilters.Add("Bid Status", ddlBidStatus.SelectedItem.Text);
            dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
            VDMUtil.ExportGridToExcel(gdvWorkArea, "Work Area", "WorkArea", dictionaryFilters, null);

        }

        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }

        //protected void ddlYear_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    BindWorkAreaStatus();
        //    BindEventCode();
        //}

        protected void ddlBUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            //BindYear();
            //BindWorkAreaStatus();
            BindEventCode();
        }

        protected void ddlBidStatus_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            BindBidGrid();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindBidGrid();

            
        }

        protected void ddlBUnit_DataBinding(object sender, EventArgs e)
        {
           // BindEventCode();
        }

        protected void gdvWorkArea_PreRender(object sender, EventArgs e)
        {
            if (gdvWorkArea.Rows.Count > 0)
            {
                //This replaces <td> with <th> and adds the scope attribute
                gdvWorkArea.UseAccessibleHeader = true;

                //This will add the <thead> and <tbody> elements
                gdvWorkArea.HeaderRow.TableSection = TableRowSection.TableHeader;

            }
        }

        //protected void ddlYear_DataBound(object sender, EventArgs e)
        //{
        //    BindWorkAreaStatus();
        //}
    }
}