﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Data.SqlClient;
using DataAccess;
using System.IO;

namespace VMT
{
    public partial class SpOpenforContRetreat : System.Web.UI.Page
    {
        string m_SP_SPROCT_SEL_BUSINESS_UNIT = Properties.Settings.Default.SP_SPROCT_SEL_BUSINESS_UNIT;
        string m_SP_SPROCT_SEL_YEAR = Properties.Settings.Default.SP_SPROCT_SEL_YEAR;
        string m_SP_SPROCT_SEL_ALL_EVENTCODE = Properties.Settings.Default.SP_SPROCT_SEL_ALL_EVENTCODE;
        string m_SP_SPROCT_OPEN_CONT_RETREAT = Properties.Settings.Default.SP_SPROCT_OPEN_CONT_RETREAT;
        string m_SP_SPROCT_UPD_OPN_CONT_RETREAT = Properties.Settings.Default.SP_SPROCT_UPD_OPN_CONT_RETREAT;

        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Spray Retreatment Contractor Open";

        protected void Page_Load(object sender, EventArgs e)
        {
          

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }
                hdn_role.Value = userRole;
                BindBusinessUnit();
               // ddlBUnit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                BindYear();
               
            }
        }

        protected void ddlBUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindYear();
        }

        protected void ddlYear_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddlYear_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindGrid();
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            BindGrid();
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            int retVal = 0;
            int V_EVENT_CODE_ID;
            int V_WORK_STATUS_ID;
            int V_COMPANY_ID;
            foreach (GridViewRow row in gdvOpenContretreat.Rows)
            {
                if (((CheckBox)row.FindControl("cbSelect")).Checked)
                {

                    V_EVENT_CODE_ID = Convert.ToInt32(((Label)row.FindControl("lbl_EVENT_CODE_ID")).Text);
                    V_WORK_STATUS_ID = 10;
                }

                else
                {
                    V_EVENT_CODE_ID = Convert.ToInt32(((Label)row.FindControl("lbl_EVENT_CODE_ID")).Text);
                    V_WORK_STATUS_ID = 9;
                }

                V_COMPANY_ID = Convert.ToInt32(((Label)row.FindControl("lbl_COMPANY_ID")).Text);
                try
                {
                    List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                    sqlParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                    sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                    sqlParams.Add(new OleDbParameter("V_WORK_STATUS_ID", V_WORK_STATUS_ID));
                    sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                    retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPROCT_UPD_OPN_CONT_RETREAT, sqlParams);
                }
                catch
                {
                }
            }

            if (retVal == 1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Update successful')", true);
            }
            ResertEventcode();
            BindGrid();
        }


        protected void ResertEventcode()
        {
            int ECposition = 0;
            ECposition = Convert.ToInt32(ddlEventCode.SelectedValue);
            BindEventCode();
            ddlEventCode.SelectedValue = ECposition.ToString();
        }

        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddlBUnit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddlYear.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
                List<int> listHideColumns = new List<int>(new int[] { 4 });
                VDMUtil.ExportGridToExcel(gdvOpenContretreat, "Open for Re-Treatment Contractor", "Open_for_Re-Treatment_Contractor", dictionaryFilters, null);
            }
            catch
            {
            }
        }

        protected void gdvOpenContretreat_Sorting(object sender, GridViewSortEventArgs e)
        {
            try
            {
                VDMUtil.GridviewSorting(gdvOpenContretreat, e.SortExpression, (DataSet)ViewState["dataTable"]);
            }
            catch
            {
            }
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }
        protected void cbSelectAll_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox ChkBoxHeader = (CheckBox)gdvOpenContretreat.HeaderRow.FindControl("cbSelectAll");
            foreach (GridViewRow row in gdvOpenContretreat.Rows)
            {
                CheckBox ChkBoxRows = (CheckBox)row.FindControl("cbSelect");
                if (ChkBoxRows.Enabled == true)
                {
                    if (ChkBoxHeader.Checked == true)
                    {
                        ChkBoxRows.Checked = true;
                    }
                    else
                    {
                        ChkBoxRows.Checked = false;
                    }
                }
            }
        }

        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPROCT_SEL_BUSINESS_UNIT, ddlBUnit);
            }
            catch
            {
            }
        }

        void BindYear()
        {
            try
            {

                int V_BUSINESS_UNIT_ID = 0;

                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPROCT_SEL_YEAR, OledbParams, ddlYear);
            }
            catch
            {
            }


        }
        void BindEventCode()
        {
            try
            {
                int V_BUSINESS_UNIT_ID = 0;
                int V_YEAR = 0;

                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPROCT_SEL_ALL_EVENTCODE, OledbParams, ddlEventCode);
            }
            catch
            {
            }


        }


        void BindGrid()
        {
            try
            {
                int V_BUSINESS_UNIT_ID = 0;
                int V_YEAR_ID = 0;
                int V_EVENT_CODE_ID = 0;
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_YEAR_ID = Convert.ToInt32(ddlYear.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", V_YEAR_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SPROCT_OPEN_CONT_RETREAT, OledbParams, gdvOpenContretreat);
                ViewState["dataTable"] = gdvOpenContretreat.DataSource as DataSet;
                gdvOpenContretreat.SelectedIndex = -1;

                if (gdvOpenContretreat.Rows.Count > 0)
                {
                    //btnSave.Visible = true;
                    btnExportExcel.Visible = true;
                }
                else
                {
                    // btnSave.Visible = false;
                    btnExportExcel.Visible = false;
                }

                //checks user role
                if (gdvOpenContretreat.Rows.Count > 0 && hdn_role.Value == "2")
                {
                    btnSave.Visible = true;
                }
                else if (gdvOpenContretreat.Rows.Count > 0 && hdn_role.Value == "3")
                {
                    btnSave.Visible = true;
                }
                else if (gdvOpenContretreat.Rows.Count > 0 && hdn_role.Value == "1")
                {
                    btnSave.Visible = false;
                }
                else if (hdn_role.Value == "0")
                {
                    Response.Redirect("Default.aspx");
                }
            //    userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            //    if (gdvOpenContretreat.Rows.Count > 0 && userRole == "Edit")
            //    {
            //        btnSave.Visible = true;
            //    }
            //    else
            //    {
            //        btnSave.Visible = false;
            //    }
            }

            catch
            {
            }


        }

        protected void gdvOpenContretreat_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Label lblExists = (Label)e.Row.FindControl("lbl_LINE_EXISTS");
                CheckBox chkbox = (CheckBox)e.Row.FindControl("cbSelect");
                if (lblExists.Text == "1")
                {
                    chkbox.Enabled = false;
                }
                else
                {
                    chkbox.Enabled = true;
                }
            }
        }
    }
}