﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.SqlClient;

namespace VMT
{
    public partial class RateTypes : System.Web.UI.Page
    {
        string m_SP_SELECT_RATE_TYPES = Properties.Settings.Default.SP_SELECT_RATE_TYPES;
        string m_SP_VDM_RATE_TYPES_INS_UPD = Properties.Settings.Default.SP_VDM_RATE_TYPES_INS_UPD;
        string m_SP_SELECT_RATE_TYPES_DETAIL = Properties.Settings.Default.SP_SELECT_RATE_TYPES_DETAIL;
        string m_SP_SELECT_TRIM_UOM = Properties.Settings.Default.SP_SELECT_TRIM_UOM;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Trim Types";

        protected void Page_Load(object sender, EventArgs e)
        {
            
            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            //if (userRole == "Edit")
            //{
            //    btn_add.Visible = true;
            //}
            //else
            //{
            //    btn_add.Visible = false;
            //}

            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                bindGrid();
                bindUOM();
                btn_create.Visible = false;
                btn_delete.Visible = false;

            }
        }
        void bindUOM()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SELECT_TRIM_UOM, ddl_UOM);
            }
            catch
            {
            }
        }
        private void bindGrid()
        {
            try
            {
                DataAccessUtility.BindGridViewViaProcedure(m_SP_SELECT_RATE_TYPES, gdv_list);
                gdv_list.SelectedIndex = -1;
            }
            catch
            {
            }
        }
        protected void btn_add_Click(object sender, EventArgs e)
        {
            if (btn_add.Text == "Add New")
            {
                AddUpdate("INSERT");
            }
            else if (btn_add.Text == "Update")
            {
                AddUpdate("UPDATE");
            }
        }

        private void AddUpdate(string strOperation)
        {
            if (txt_RateTypename.Text.Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate Type name could not be blank!')", true);
                txt_RateTypename.Focus();
                return;
            }
            int RATE_TYPE_ID = 0;
            if (strOperation == "INSERT")
            {
                RATE_TYPE_ID = 0;
            }
            else
            {
                RATE_TYPE_ID = Int32.Parse(hdn_keyid.Value);
            }

            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_RATE_TYPE_ID", RATE_TYPE_ID));
                sqlParams.Add(new OleDbParameter("V_RATE_TYPE_NAME", txt_RateTypename.Text.Trim()));               
                sqlParams.Add(new OleDbParameter("V_RATE_TYPE_DESCRIPTION", txt_rateDesc.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_UOM", ddl_UOM.SelectedValue));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
               // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_RATE_TYPES_INS_UPD, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                bindGrid();
                clearfields();
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate Type name already exists')", true);
            }

        }

        protected void gdv_list_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
        {
            GridViewRow row = gdv_list.Rows[e.NewSelectedIndex];
            hdn_keyid.Value = row.Cells[1].Text;

          //  if (userRole == "3")
          //  {
                btn_add.Text = "Update";
                btn_create.Visible = true;
                btn_delete.Visible = true;
          //  }
            getdetail();
        }
        void getdetail()
        {
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            try
            {
                OleDbParams.Add(new OleDbParameter("V_RATE_TYPE_ID", hdn_keyid.Value));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SELECT_RATE_TYPES_DETAIL, OleDbParams);


                //bind the fields 
                txt_RateTypename.Text = ds.Tables[0].Rows[0]["RATE_TYPE_NAME"].ToString();
                txt_rateDesc.Text = ds.Tables[0].Rows[0]["RATE_TYPE_DESCRIPTION"].ToString();
                ddl_UOM.SelectedValue = ds.Tables[0].Rows[0]["UOM_ID"].ToString();
            }
            catch
            {
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }
        void clearfields()
        {
            btn_create.Visible = false;
            btn_delete.Visible = false;
            hdn_keyid.Value = "";
            btn_add.Text = "Add New";
            txt_RateTypename.Text = "";
            txt_rateDesc.Text = "";
            bindUOM();
            
        }

        protected void btn_reset_Click(object sender, EventArgs e)
        {
            if (hdn_keyid.Value == "")
            {
                clearfields();
            }

            else
            {
                getdetail();
            }
        }

        protected void btn_delete_Click(object sender, EventArgs e)
        {
            AddUpdate("DELETE");
        }

        protected void btn_create_Click(object sender, EventArgs e)
        {
            clearfields();
        }

        protected void gdv_list_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[1].Visible = false; // hides the first column
        }
    }
}