﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using DataAccess;
using System.Data.OleDb;
using System.Data;

namespace VMT
{
    public partial class Project_Mapping : System.Web.UI.Page
    {
        string m_SP_VDM_SELECT_BU_PM = Properties.Settings.Default.SP_VDM_SELECT_BU_PM;
        string m_SP_VDM_SELECT_YEAR_PM = Properties.Settings.Default.SP_VDM_SELECT_YEAR_PM;
        string m_SP_VDM_SELECT_PROJECT_CODE_PM = Properties.Settings.Default.SP_VDM_SELECT_PROJECT_CODE_PM;
        string m_SP_VDM_SELECT_EVENT_CODE_PM = Properties.Settings.Default.SP_VDM_SELECT_EVENT_CODE_PM;
        string m_SP_VDM_SELECT_SECTION_CODE_PM = Properties.Settings.Default.SP_VDM_SELECT_SECTION_CODE_PM;
        string m_SP_VDM_SELECT_WORK_AREAS_PM = Properties.Settings.Default.SP_VDM_SELECT_WORK_AREAS_PM;
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "View Project Mapping";

        protected void Page_Load(object sender, EventArgs e)
        {
            

            if (!Page.IsPostBack)
            {

                //checks user role
                // userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                BindBusinessUnit();
                ddlBUnit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                BindYear();
            }
        }

        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_BU_PM, ddlBUnit);
            }
            catch
            {
            }
        }

        protected void ddlBUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindYear();
        }

        protected void ddlBUnit_DataBound(object sender, EventArgs e)
        {
            BindYear();
        }

        protected void ddlYear_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindProjectCode();
        }

        protected void dddlProjectCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            GetEventCode();
            BindSectionCode();
        }

        void BindYear()
        {
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                List<OleDbParameter> OledbParam = new List<OleDbParameter>();
                OledbParam.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_YEAR_PM, OledbParam, ddlYear);
            }
            catch
            {
            }
        }

        void BindProjectCode()
        {
            string V_PROJECT_CODE = string.Empty;
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_PROJECT_CODE = ddlYear.SelectedValue;

                List<OleDbParameter> OledbParam = new List<OleDbParameter>();
                OledbParam.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParam.Add(new OleDbParameter("V_YEAR_ID", V_PROJECT_CODE));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_PROJECT_CODE_PM, OledbParam, ddlProjectCode);
                if (ddlProjectCode.Items.Count <= 0)
                {
                    txtEventCode.Text = "";
                    txtEventDescription.Text = "";
                    txtEventId.Text = "";
                    txtWorkArea.Text = "";
                    ddlSectionCode.DataSource = "";
                    txtWorkAreaDesc.Text = "";
                    ddlSectionCode.DataBind();
                }
            }
            catch
            {
            }
        }

        void GetEventCode()
        {
            try
            {
                    DataSet ds = new DataSet();
                    List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                    OleDbParams.Add(new OleDbParameter("V_EVENT_CODE", Convert.ToInt32(ddlProjectCode.SelectedValue)));
                    ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_VDM_SELECT_EVENT_CODE_PM, OleDbParams);

                    //bind the fields 

                    txtEventCode.Text = ds.Tables[0].Rows[0]["event_code"].ToString();
                    txtEventDescription.Text = ds.Tables[0].Rows[0]["event_code_description"].ToString();
                    txtEventId.Text = ds.Tables[0].Rows[0]["event_code_id"].ToString();
            }
            catch
            {
            }
        }

        protected void ddlProjectCode_DataBound(object sender, EventArgs e)
        {
            GetEventCode();
            BindSectionCode();
        }

        protected void ddlSectionCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            GetWorkArea();
        }

        protected void ddlSectionCode_DataBound(object sender, EventArgs e)
        {
            GetWorkArea();
        }

        void BindSectionCode()
        {
            int V_YEAR_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_YEAR_ID = Convert.ToInt32(ddlYear.SelectedValue);
                V_EVENT_CODE_ID =Convert.ToInt32(ddlProjectCode.SelectedValue);


                List<OleDbParameter> OledbParam = new List<OleDbParameter>();
                OledbParam.Add(new OleDbParameter("V_YEAR_ID", V_YEAR_ID));
                OledbParam.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_SECTION_CODE_PM, OledbParam, ddlSectionCode);
            }
            catch
            {
            }
        }

        void GetWorkArea()
        {
            try
            {
                DataSet ds = new DataSet();
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE", Convert.ToInt32(ddlProjectCode.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("V_SECTION_CODE", ddlSectionCode.SelectedValue));
                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_VDM_SELECT_WORK_AREAS_PM, OleDbParams);

                //bind the fields 

                txtWorkArea.Text = ds.Tables[0].Rows[0]["WORK_AREA_ID"].ToString();
                txtWorkAreaDesc.Text = ds.Tables[0].Rows[0]["WORK_AREA_DESC"].ToString();
            }
            catch
            {
            }
        }

        protected void ddlYear_DataBound(object sender, EventArgs e)
        {
            BindProjectCode();
        }
    }
}