﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.OleDb;
using System.Data;
using DataAccess;

namespace VMT
{
    public partial class ProjectCompletionStatus : System.Web.UI.Page
    {
        string m_SP_PCS_SELECT_BUSINESS_UNIT = Properties.Settings.Default.SP_PCS_SELECT_BUSINESS_UNIT;
        string m_SP_PCS_SELECT_EVENT_CODE = Properties.Settings.Default.SP_PCS_SELECT_EVENT_CODE;
        string m_SP_PCS_SELECT_WORK_AREA = Properties.Settings.Default.SP_PCS_SELECT_WORK_AREA;
        string m_SP_PCS_SEL_PJT_COMPL_STS = Properties.Settings.Default.SP_PCS_SEL_PJT_COMPL_STS;
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string m_SP_PCS_SELECT_COMPANY = Properties.Settings.Default.SP_PCS_SELECT_COMPANY;
        string m_SP_PCS_SEL_TRIM_LINE_TRANS = Properties.Settings.Default.SP_PCS_SEL_TRIM_LINE_TRANS;
        string pageName = "Project Completion Status";

        protected void Page_Load(object sender, EventArgs e)
        {
            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {
                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }

                if (userRole == "0")
                {
                    //System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                BindBusinessUnit();
                ddlBUnit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                //BindYear();
                //ddlYear.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                //BindAllWorkAreaStatus();
                //BindWorkAreaStatus();
                BindEventCode();
            }
        }

        protected void ddlBUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindEventCode();
        }

        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_PCS_SELECT_BUSINESS_UNIT, ddlBUnit);
            }
            catch
            {
            }
        }

        void BindEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
            //int V_YEAR = 0;
            //int V_STATUS = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                //V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);
                //V_STATUS = Convert.ToInt32(ddlBidStatus.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                //OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                //OledbParams.Add(new OleDbParameter("V_STATUS", V_STATUS));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_PCS_SELECT_EVENT_CODE, OledbParams, ddlEventCode);
            }
            catch
            {
            }

        }

        protected void ddlWorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindCompany();
        }

        protected void ddlWorkArea_DataBound(object sender, EventArgs e)
        {
            BindCompany();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindWorkArea();
        }

        void BindWorkArea()
        {
            int V_BUSINESS_UNIT_ID = 0;
            //int V_YEAR = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                //V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                //OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_PCS_SELECT_WORK_AREA, OledbParams, ddlWorkArea);
            }
            catch
            {
            }
        }

        void BindCompany()
        {
            try
            {
                int V_BUSINESS_UNIT_ID = 0;
                int V_WORK_AREA_ID = 0;
                int V_EVENT_CODE_ID = 0;

                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                V_WORK_AREA_ID = Convert.ToInt32(ddlWorkArea.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_PCS_SELECT_COMPANY, OledbParams, ddlCompany);
            }
            catch
            {
            }


        }

        protected void ddlCompany_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindProjectGrid();
            BindPaymentDetailGrid(0);
        }

        protected void ddlCompany_DataBound(object sender, EventArgs e)
        {
            BindProjectGrid();
            BindPaymentDetailGrid(0);
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            BindWorkArea();
        }

        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
            dictionaryFilters.Add("Business Unit", ddlBUnit.SelectedItem.Text);
            dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
            dictionaryFilters.Add("Work Area", ddlWorkArea.SelectedItem.Text);
            VDMUtil.ExportGridToExcel(gdvWorkArea, "Work Area", "WorkArea", dictionaryFilters, null);

        }

        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }

        void BindProjectGrid()
        {
            int businessunit;
            int eventcode;
            int workarea;
            int company;
            try
            {
                businessunit = Int32.Parse(ddlBUnit.SelectedValue.ToString());
                eventcode = Int32.Parse(ddlEventCode.SelectedValue.ToString());
                workarea = Int32.Parse(ddlWorkArea.SelectedValue.ToString());
                company = Int32.Parse(ddlCompany.SelectedValue.ToString());
                if (ddlEventCode.SelectedValue.Trim() == "")
                    eventcode = 0;
                else
                    eventcode = Int32.Parse(ddlEventCode.SelectedValue.ToString());
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();

                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", businessunit));
                sqlParams.Add(new OleDbParameter("V_EVENTCODE", eventcode));
                sqlParams.Add(new OleDbParameter("V_WORKAREAID", workarea));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", company));

                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_PCS_SEL_PJT_COMPL_STS, sqlParams, gdvWorkArea);
                ViewState["dataTable"] = gdvWorkArea.DataSource as DataSet;

                if (gdvWorkArea.Rows.Count > 0)
                    btnExportExcel.Visible = true;
                else
                    btnExportExcel.Visible = false;
            }
            catch
            {
            }
        }

        protected void gdvWorkArea_Sorting(object sender, GridViewSortEventArgs e)
        {
            VDMUtil.GridviewSorting(gdvWorkArea, e.SortExpression, (DataSet)ViewState["dataTable"]);
        }
        protected void gdvWorkArea_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            BindPaymentDetailGrid(Convert.ToInt32(e.CommandArgument));
        }

        void BindPaymentDetailGrid(int line_id)
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_LINE_ID", line_id));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_PCS_SEL_TRIM_LINE_TRANS, OledbParams, gdv_Paydetail);
            }
            catch
            {
            }
        }

        protected void ImageButton1_Click(object sender, ImageClickEventArgs e)
        {

        }
    }
}