﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Data.SqlClient;
using DataAccess;
using System.IO;

namespace VMT
{
    public partial class Payment : System.Web.UI.Page
    {
        string m_SP_SELECT_BU_PAYMENT = Properties.Settings.Default.SP_SELECT_BU_PAYMENT;
        string m_SP_SELECT_PAYMENT_YEAR_BU = Properties.Settings.Default.SP_SELECT_PAYMENT_YEAR_BU;
        string m_SP_SELECT_EC_FOR_PAYMENT = Properties.Settings.Default.SP_SELECT_EC_FOR_PAYMENT;
        string m_SP_SELECT_PAYMENT_HEADER = Properties.Settings.Default.SP_SELECT_PAYMENT_HEADER;
        string m_SP_SELECT_PAYMENT_DETAIL = Properties.Settings.Default.SP_SELECT_PAYMENT_DETAIL;
        string m_VDM_PAYMENT_DETAIL_INS_DEL = Properties.Settings.Default.SP_VDM_PAYMENT_DETAIL_INS_DEL;
        string m_SP_SELECT_COMPANY_FOR_PAYMENT = Properties.Settings.Default.SP_SELECT_COMPANY_FOR_PAYMENT;
        
        


        string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Payment Status";

        protected void Page_Load(object sender, EventArgs e)
        {
           
            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            //if (userRole == "Edit")
            //{
            //    rowAdd.Visible = true;
            //    rowAddBtn.Visible = true;
            //}
            //else
            //{
            //    rowAdd.Visible = false;
            //    rowAddBtn.Visible = false;
            //}

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
           // scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {


                //checks user role
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }
                hdn_role.Value = userRole;
                if (userRole == "2")
                {
                    rowAdd.Visible = true;
                    rowAddBtn.Visible = true;
                }
                else if (userRole == "3")
                {
                    rowAdd.Visible = true;
                    rowAddBtn.Visible = true;
                }
                else if (userRole == "1")
                {
                    rowAdd.Visible = false;
                    rowAddBtn.Visible = false;
                }
                else if (userRole == "0")
                {
                    Response.Redirect("Default.aspx");
                }

                BindBusinessUnit();
                ddl_Bunit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                BindYear();
              //  ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                BindEventCode();
                CreateNew.Visible = false;
            }

        }
        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SELECT_BU_PAYMENT, ddl_Bunit);
            }
            catch
            {
            }
        }
        void BindYear()
        {
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_PAYMENT_YEAR_BU, OledbParams, ddl_Year);
            }
            catch
            {
            }
        }
        void BindEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_EC_FOR_PAYMENT, OledbParams, ddlEventCode);
            }
            catch
            {
            }
        }

        void BindCompany()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_COMPANY_FOR_PAYMENT, OledbParams, ddlCompany);

            }
            catch
            {
            }
        }
        protected void ddl_Year_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindYear();
        }

        protected void ddl_Bunit_DataBound(object sender, EventArgs e)
        {
            BindYear();
        }

        protected void ddl_Year_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindCompany();

           
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            BindCompany();

           
        }


        void BindPaymentHeadGrid()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;           
            int V_EVENT_CODE_ID = 0;
            int V_COMPANY_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddlCompany.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SELECT_PAYMENT_HEADER, OledbParams, gdv_Payheader);
                gdv_Payheader.SelectedIndex = -1;
                this.gdv_Payheader.SelectRow(0);
                gdv_Payheader_SelectedIndexChanged(this.gdv_Payheader, new EventArgs());              
            }
            catch
            {                
            }
        }

        void BindPaymentDetailGrid(int payment_id)
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_PAYMENT_ID", payment_id));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SELECT_PAYMENT_DETAIL, OledbParams, gdv_Paydetail);
            }
            catch
            {
            }
        }

        protected void gdv_Payheader_SelectedIndexChanged(object sender, EventArgs e)
        {

            
            GridViewRow row = gdv_Payheader.SelectedRow;
            BindPaymentDetailGrid(Convert.ToInt32(row.Cells[8].Text));
            hdn_PAYMENT_ID.Value = row.Cells[8].Text;
        }

        protected void btnGo_Click(object sender, EventArgs e)
        {
            gdv_Paydetail.DataSource = null;
            gdv_Paydetail.DataBind();
            BindPaymentHeadGrid();
            
        }

        protected void btnshowhide_Click(object sender, ImageClickEventArgs e)
        {
            if (CreateNew.Visible == true)
            {
                CreateNew.Visible = false;
                btnshowhide.ImageUrl = "resource_gallery/graphics/plus.png";
            }
            else
            {
                btnshowhide.ImageUrl = "resource_gallery/graphics/minus.png";
                CreateNew.Visible = true;
            }
        }

        protected void btn_addRates_Click(object sender, EventArgs e)
        {


            if (hdn_PAYMENT_ID.Value.Trim() == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select Work Area for Payment Details!')", true);
                btnGo.Focus();
                return;
            }

            double V_PAYMENT_AMOUNT = 0.0;
            try
            {
                V_PAYMENT_AMOUNT = Convert.ToDouble(txt_PAYMENT_AMOUNT.Text.Trim());
            }
            catch (Exception ex)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Payment Amount could not be non-Numeric!')", true);
                txt_PAYMENT_AMOUNT.Focus();
                return;
            }

            string strOperation = "";
            int V_OBJECTID = 0;
            int V_PAYMENT_ID = 0;           
            string V_PAYMENT_STATUS = " ";
            try
            {
                strOperation = "INSERT";
                V_PAYMENT_STATUS = Convert.ToString(ddl_PAYMENT_STATUS.SelectedValue);
                V_PAYMENT_ID = Convert.ToInt32(hdn_PAYMENT_ID.Value);



                AddDelete(strOperation, V_OBJECTID, V_PAYMENT_ID, V_PAYMENT_AMOUNT, V_PAYMENT_STATUS);




                BindPaymentDetailGrid(V_PAYMENT_ID);
                BindPaymentHeadGrid();
                resetControl();
            }
            catch
            {
            }
        }
        private void resetControl ()
        {
            txt_PAYMENT_AMOUNT.Text = "";
        }
        private void AddDelete(string strOperation, int V_OBJECTID, int V_PAYMENT_ID, double V_PAYMENT_AMOUNT, string V_PAYMENT_STATUS)
        {
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_OBJECTID", V_OBJECTID));
                sqlParams.Add(new OleDbParameter("V_PAYMENT_ID", V_PAYMENT_ID));
                sqlParams.Add(new OleDbParameter("V_PAYMENT_AMOUNT", V_PAYMENT_AMOUNT));
                sqlParams.Add(new OleDbParameter("V_PAYMENT_STATUS", V_PAYMENT_STATUS));
                
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_VDM_PAYMENT_DETAIL_INS_DEL, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {

                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation.ToLower() + " successful.')", true);

            }
            else if (retVal == -1)
            {
                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation.ToLower() + " failed.')", true);
            }

        }

        protected void gdv_Paydetail_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            GridViewRow row = (GridViewRow)gdv_Paydetail.Rows[e.RowIndex];
            try
            {
                int V_OBJECTID = Convert.ToInt32((row.FindControl("lbl_OBJECTID") as Label).Text);
                int V_PAYMENT_ID = Convert.ToInt32((row.FindControl("lbl_PAYMENT_ID") as Label).Text);


                double V_RATE_TYPE_AMOUNT = 0.0;

                AddDelete("DELETE", V_OBJECTID, V_PAYMENT_ID, V_RATE_TYPE_AMOUNT, "");
                BindPaymentDetailGrid(V_PAYMENT_ID);
                BindPaymentHeadGrid();
                resetControl();
            }
            catch
            {
            }
        }

        protected void gdv_Payheader_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[8].Visible = false;
        }

        protected void gdv_Paydetail_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[4].Visible = false;
            e.Row.Cells[5].Visible = false;

            //LinkButton linkButton = (LinkButton)e.Row.FindControl("LinkButton1");
            //Image img = (Image)e.Row.FindControl("img1");
            //checks user role
           // userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            if (hdn_role.Value == "2")
            {
                e.Row.Cells[3].Visible = true;
            }
            else if (hdn_role.Value == "3")
            {
                e.Row.Cells[3].Visible = true;
            }
            else
            {
                e.Row.Cells[3].Visible = false;
            }
        }

        protected void gdv_Payheader_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[5].HorizontalAlign = HorizontalAlign.Right;
            e.Row.Cells[6].HorizontalAlign = HorizontalAlign.Right;
            e.Row.Cells[7].HorizontalAlign = HorizontalAlign.Right;
        }

        protected void ddlCompany_SelectedIndexChanged(object sender, EventArgs e)
        {
            gdv_Paydetail.DataSource = null;
            gdv_Paydetail.DataBind();
            BindPaymentHeadGrid();
        }

        protected void ddlCompany_DataBound(object sender, EventArgs e)
        {
            gdv_Paydetail.DataSource = null;
            gdv_Paydetail.DataBind();
            BindPaymentHeadGrid();
        }
    }
}