﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using DataAccess;
using System.Data;
using System.Data.SqlClient;
using System.Data.OleDb;
using System.Web.Services;
using System.Text;
using System.Web.Script.Serialization;
using System.Drawing;
using System.Web.UI.HtmlControls;

namespace VMT
{
    public partial class FlightIssueMapView : System.Web.UI.Page
    {
        string m_SP_FM_SEL_INSPECTION_SUB_TYPE = Properties.Settings.Default.SP_FM_SEL_INSPECTION_SUB_TYPE;
        string m_SP_FM_SEL_INSP_SUB_TYPE_ALL = Properties.Settings.Default.SP_FM_SEL_INSP_SUB_TYPE_ALL;
        string m_SP_FM_SEL_ISSUE_STATUS_ALL = Properties.Settings.Default.SP_FM_SEL_ISSUE_STATUS_ALL;
        string m_SP_FM_SEL_ISSUE_TYPE = Properties.Settings.Default.SP_FM_SEL_ISSUE_TYPE;
        string m_SP_FM_SEL_ISSUE_SUB_TYPE = Properties.Settings.Default.SP_FM_SEL_ISSUE_SUB_TYPE;
        string m_SP_FM_SEL_FL_ASSIGNEDTO = Properties.Settings.Default.SP_FM_SEL_FL_ASSIGNEDTO;
        string m_SP_FM_SEL_FL_ISSUE_LIST = Properties.Settings.Default.SP_FM_SEL_FL_ISSUE_LIST;
        string m_SP_FM_SEL_ASSIGNEDTO = Properties.Settings.Default.SP_FM_SEL_ASSIGNEDTO;
        string m_SP_FM_SEL_COMP_ASSIGNEDTO = Properties.Settings.Default.SP_FM_SEL_COMP_ASSIGNEDTO;
        string m_SP_FM_SEL_ASSIGNEDTO_SEQ = Properties.Settings.Default.SP_FM_SEL_ASSIGNEDTO_SEQ;
        string m_SP_FM_UPD_ASSIGNEDTO_SEQ = Properties.Settings.Default.SP_FM_UPD_ASSIGNEDTO_SEQ;
        string m_SP_FM_SEL_ISSUE_STATUS = Properties.Settings.Default.SP_FM_SEL_ISSUE_STATUS;
        string m_SP_FM_SEL_ISSUE_STATUS_SEQ = Properties.Settings.Default.SP_FM_SEL_ISSUE_STATUS_SEQ;
        string m_SP_FM_UPD_ISSUE_STATUS_SEQ = Properties.Settings.Default.SP_FM_UPD_ISSUE_STATUS_SEQ;
        string m_SP_FM_SEL_EVENTCODE = Properties.Settings.Default.SP_FM_SEL_EVENTCODE;
        string m_SP_FM_SEL_WORKAREA = Properties.Settings.Default.SP_FM_SEL_WORKAREA;

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                bindEventCode();
                bindWorkArea();
                bindInspectionGroup();
                //bindInspectionGroupAll();
                bindAssignedTo();
                bindCrew();
                bindUpdatedIssueStatus();

                DataTable dt = new DataTable();
                dt.Columns.Add("sequencer");
                dt.Columns.Add("Idesc");
                dt.Columns.Add("X");
                dt.Columns.Add("Y");
                //dt.Columns.Add("assignedto");
                DataRow row1 = dt.NewRow();
                row1["sequencer"] = "";
                row1["Idesc"] = "No Records.";
                row1["X"] = "";
                row1["Y"] = "";
                //row1["assignedto"] = "";
                dt.Rows.Add(row1);
                gdv_list.DataSource = dt;
                gdv_list.DataBind();
                lblNoRecords.Text = "0 Records";
                //gdv_list.Attributes.Add("class", "tblblank");
                //ddlInspectionGroup.Attributes.Add("onchange", "InspectionGroupChange();"); 
                //ddlInspectionGroup.Enabled = false;
                //btnRemove.Attributes.Add("style", "display:none");
            }
        }

        void bindEventCode()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FM_SEL_EVENTCODE, ddlEventCode);
            }
            catch
            {
            }
        }
        void bindWorkArea()
        {
            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();

                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", ddlEventCode.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_FM_SEL_WORKAREA, OleDbParams, ddlWorkArea);
            }
            catch
            {
            }
        }
        void bindInspectionGroup()
        {
            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", ddlEventCode.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_WORK_AREA_ID", ddlWorkArea.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_FM_SEL_INSPECTION_SUB_TYPE, OleDbParams, ddlInspSubType);

                //DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FM_SEL_INSPECTION_SUB_TYPE, ddlInspSubType);
            }
            catch
            {
            }
        }
        //void bindInspectionGroupAll()
        //{
        //    try
        //    {
        //        DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FM_SEL_INSP_SUB_TYPE_ALL, ddlInspectionGroup);
        //    }
        //    catch
        //    {
        //    }
        //}
        void bindIssueStatus()
        {
            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", ddlEventCode.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_WORK_AREA_ID", ddlWorkArea.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_INSPECTION_SUB_TYPE", ddlInspSubType.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_ISSUE_ID", ddlIssueType.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_ISSUE_SUBTYPE_ID", ddlIssueSubType.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_FM_SEL_ISSUE_STATUS_ALL, OleDbParams, ddlIssueStatus);
            }
            catch
            {
            }
        }
        void bindIssueType()
        {
            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", ddlEventCode.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_WORK_AREA_ID", ddlWorkArea.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_INSPECTION_SUB_TYPE", ddlInspSubType.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_FM_SEL_ISSUE_TYPE,OleDbParams,ddlIssueType);
            }
            catch
            {
            }
        }
        void bindIssueSubType()
        {
            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", ddlEventCode.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_WORK_AREA_ID", ddlWorkArea.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_INSPECTION_SUB_TYPE", ddlInspSubType.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_ISSUE_ID", ddlIssueType.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_FM_SEL_ISSUE_SUB_TYPE, OleDbParams, ddlIssueSubType);
            }
            catch
            {
            }
        }
        void bindIssueAssignedTo()
        {
            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", ddlEventCode.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_WORK_AREA_ID", ddlWorkArea.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_INSPECTION_SUB_TYPE", ddlInspSubType.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_ISSUE_ID", ddlIssueType.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_ISSUE_SUBTYPE_ID", ddlIssueSubType.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_ISSUE_STATUS_ID", ddlIssueStatus.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_FM_SEL_FL_ASSIGNEDTO, OleDbParams, ddlIssueAssignedTo);
            }
            catch
            {
            }
        }
        void bindAssignedTo()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FM_SEL_ASSIGNEDTO, ddlAssignedTo);
            }
            catch
            {
            }
        }
        void bindCrew()
        {
            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();

                OleDbParams.Add(new OleDbParameter("V_CONTRACTOR_ID", ddlAssignedTo.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_FM_SEL_COMP_ASSIGNEDTO, OleDbParams, ddlCrew);
            }
            catch
            {
            }
        }
        void bindUpdatedIssueStatus()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FM_SEL_ISSUE_STATUS, ddlUpdatedStatus);
            }
            catch
            {
            }
        }

        //private void bindGrid()
        //{
        //    ClearLables();
        //    string frmdt = string.Empty;
        //    string todt = string.Empty;
        //    if (chkDate.Checked && txtFromDt.Text != "" && txtToDt.Text != "")
        //    {
        //        frmdt = txtFromDt.Text.Trim();
        //        todt = txtToDt.Text.Trim();
        //    }

        //    try
        //    {
        //        List<OleDbParameter> OleDbParams = new List<OleDbParameter>();

        //        OleDbParams.Add(new OleDbParameter("V_INSPECTIONSUBTYPE", ddlInspSubType.SelectedValue));
        //        OleDbParams.Add(new OleDbParameter("V_ISSUE_ID", Convert.ToInt32(ddlIssueType.SelectedValue)));
        //        OleDbParams.Add(new OleDbParameter("V_ISSUE_SUBTYPE_ID", Convert.ToInt32(ddlIssueSubType.SelectedValue)));
        //        OleDbParams.Add(new OleDbParameter("V_ISSUE_STATUS_ID", Convert.ToInt32(ddlIssueStatus.SelectedValue)));
        //        OleDbParams.Add(new OleDbParameter("V_ASSIGNED_TO", Convert.ToInt32(ddlIssueAssignedTo.SelectedValue)));
        //        OleDbParams.Add(new OleDbParameter("V_FRM_CREATION_DATE", frmdt));
        //        OleDbParams.Add(new OleDbParameter("V_TO_CREATION_DATE", todt));

        //        DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_FM_SEL_FL_ISSUE_LIST, OleDbParams, gdv_list);
        //        gdv_list.SelectedIndex = -1;

        //        //call javascript method to load a new layer which sequencer is available on the gridview
        //        ScriptManager.RegisterStartupScript(this.Page, Page.GetType(), "text", "LoadNewLayer()", true);
        //    }
        //    catch
        //    {
        //    }
        //}
                
        protected void gdv_list_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                e.Row.Attributes["onclick"] = Page.ClientScript.GetPostBackClientHyperlink(gdv_list, "Select$" + e.Row.RowIndex);
                e.Row.Attributes["style"] = "cursor:pointer";
                e.Row.ToolTip = "Click to select this row.";
            }
        }

        //protected void btnSearch_Click(object sender, EventArgs e)
        //{
        //    bindGrid();
        //}

        [WebMethod]
        public static string getdetail(string Sequencer)
        {
            DataSet ds = new DataSet();
            try
            {
                List<OleDbParameter> OleDbParam = new List<OleDbParameter>();

                OleDbParam.Add(new OleDbParameter("V_SEQUENCER", Sequencer));
                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam("Vegdbo.SP_FM_SEL_FL_ISSUE_DETAIL", OleDbParam);
                
            }
            catch
            {
            }
            finally
            {
            }
            return ds.GetXml();
        }

        [WebMethod]
        public static string ReturnSearchResult(int eventCodeId,int workAreaId,string inspSubType,int issueId,int issueSubTypeId,int issueStatusId,string issueAssignedTo,string frmdt,string todt)
        {
            DataSet ds = new DataSet();

            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", eventCodeId));
                OleDbParams.Add(new OleDbParameter("V_WORK_AREA_ID", workAreaId));
                OleDbParams.Add(new OleDbParameter("V_INSPECTIONSUBTYPE", inspSubType));
                OleDbParams.Add(new OleDbParameter("V_ISSUE_ID", Convert.ToInt32(issueId)));
                OleDbParams.Add(new OleDbParameter("V_ISSUE_SUBTYPE_ID", Convert.ToInt32(issueSubTypeId)));
                OleDbParams.Add(new OleDbParameter("V_ISSUE_STATUS_ID", Convert.ToInt32(issueStatusId)));
                OleDbParams.Add(new OleDbParameter("V_ASSIGNED_TO", issueAssignedTo));
                OleDbParams.Add(new OleDbParameter("V_FRM_CREATION_DATE", frmdt));
                OleDbParams.Add(new OleDbParameter("V_TO_CREATION_DATE", todt));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam("Vegdbo.SP_FM_SEL_FL_ISSUE_LIST", OleDbParams);
               
            }
            catch
            {
            }

            return ds.GetXml();
        }

        [WebMethod]
        public static string GetSequencerDetails(int Sequencer)
        {
            DataTable dt = new DataTable();
            //Serialize datatable to return
            StringBuilder sb = new StringBuilder();
            List<Dictionary<string, object>> rows = new List<Dictionary<string, object>>();
            try
            {
                List<OleDbParameter> OleDbParam = new List<OleDbParameter>();

                OleDbParam.Add(new OleDbParameter("V_SEQUENCER", Sequencer));
                dt = DataAccessUtility.SelectDataTableViaStoreProcedureParam("Vegdbo.SP_FM_SEL_FL_ISSUE_INFO", OleDbParam);


                foreach (DataRow dr in dt.Rows)
                {
                    Dictionary<string, object> Dictionary = new Dictionary<string, object>();
                    foreach (DataColumn dc in dt.Columns)
                    {
                        Dictionary.Add(dc.ColumnName, dr[dc.ColumnName].ToString());
                    }
                    rows.Add(Dictionary);
                }

                JavaScriptSerializer js = new JavaScriptSerializer();
                js.Serialize(rows, sb);
            }
            catch
            {
            }
            finally
            {
                dt.Clear();
                dt.Dispose();
            }
            return sb.ToString();
            
        }

        //protected void gdv_list_RowCreated(object sender, GridViewRowEventArgs e)
        //{
        //    e.Row.Cells[1].Visible = false; // hides the first column
        //}

        //protected void gdv_list_SelectedIndexChanged(object sender, EventArgs e)
        //{
            //foreach (GridViewRow row in gdv_list.Rows)
            //{
            //    if (row.RowIndex == gdv_list.SelectedIndex)
            //    {
            //        row.BackColor = ColorTranslator.FromHtml("#A1DCF2");
            //        row.ToolTip = string.Empty;
            //    }
            //    else
            //    {
            //        row.BackColor = ColorTranslator.FromHtml("#FFFFFF");
            //        row.ToolTip = "Click to select this row.";
            //    }
            //}

            //string sequencer = gdv_list.SelectedRow.Cells[0].Text;
            //string desc = gdv_list.SelectedRow.Cells[1].Text;
            //decimal lat = Convert.ToDecimal(gdv_list.SelectedRow.Cells[2].Text);
            //decimal lang = Convert.ToDecimal(gdv_list.SelectedRow.Cells[3].Text);

            //hfSequencer.Value = sequencer;
            //getdetail(sequencer);
            //if (rblAssign.SelectedValue == "1")
            //{
            //    SelectAssignedTo();
            //}
            //if (rblStatus.SelectedValue == "1")
            //{
            //    SelectStatus();
            //}

           // //call javascript method to load a new layer which sequencer is available on the gridview
            //ScriptManager.RegisterStartupScript(this.Page, Page.GetType(), "text", "ZoomLocation(" + "'" + lat + "'" + "," + lang + ")", true);
        //}

        protected void rblAssign_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (rblAssign.SelectedValue == "1") //1-Selected
            {
                SelectAssignedTo();
            }
        }

        void SelectAssignedTo()
        {
            int sequencer = 0;
            DataTable dt = new DataTable();
            try
            {
                if (hfSequencer.Value != "")
                {
                    sequencer = Convert.ToInt32(hfSequencer.Value);
                }
                List<OleDbParameter> OleDbParam = new List<OleDbParameter>();

                OleDbParam.Add(new OleDbParameter("V_SEQUENCER", sequencer));
                dt = DataAccessUtility.SelectDataTableViaStoreProcedureParam(m_SP_FM_SEL_ASSIGNEDTO_SEQ, OleDbParam);
                if (dt.Rows.Count > 0)
                {
                    ddlAssignedTo.SelectedValue = dt.Rows[0]["CONTRACTOR_ID"].ToString();
                }
            }
            catch
            {
            }
            finally
            {
                dt.Clear();
                dt.Dispose();
            }
        }

        [WebMethod]
        public static string GetAssignedTo(int Sequencer)
        {
            string str = string.Empty;
            DataTable dt = new DataTable();
            try
            {
                List<OleDbParameter> OleDbParam = new List<OleDbParameter>();

                OleDbParam.Add(new OleDbParameter("V_SEQUENCER", Sequencer));
                dt = DataAccessUtility.SelectDataTableViaStoreProcedureParam("Vegdbo.SP_FM_SEL_ASSIGNEDTO_SEQ", OleDbParam);
                if (dt.Rows.Count > 0)
                {
                    str = dt.Rows[0]["CONTRACTOR_ID"].ToString();
                    str += "," + dt.Rows[0]["ASSIGNEDTO"].ToString();
                    str += "," + dt.Rows[0]["INSPECTIONDUEDATE"].ToString();
                }
            }
            catch
            {
            }
            finally
            {
                dt.Clear();
                dt.Dispose();
            }
            return str;
        }

        protected void btnAssign_Click(object sender, EventArgs e)
        {
            int sequencer = 0;
            int retVal = 0;
            int company = 0;
            int crew = 0;

            if (gdv_list.Rows.Count <= 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Please Search to Assign Due Date.')", true);
                return;
            }

            if (rblAssign.SelectedValue == "1")
            {
                if (Convert.ToInt32(ddlCrew.SelectedValue) == 0)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Please Select Crew.')", true);
                    return;
                }
                else
                {
                    crew = Convert.ToInt32(ddlCrew.SelectedValue.ToString());
                }

            }

            if (txtInspDueDt.Text == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Please Select Inspection Due Date.')", true);
                return;
            }

           

            try
            {
                company = Convert.ToInt32(ddlAssignedTo.SelectedValue);
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                if (hfSequencer.Value != "" && rblAssign.SelectedValue == "1")
                {
                    sequencer = Convert.ToInt32(hfSequencer.Value);
                    sqlParams.Add(new OleDbParameter("V_SEQUENCER", sequencer));
                    sqlParams.Add(new OleDbParameter("V_ASSIGNEDTO", company));
                    sqlParams.Add(new OleDbParameter("V_CREW_ID", crew));
                    sqlParams.Add(new OleDbParameter("V_INSPECTIONDUEDATE", txtInspDueDt.Text.Trim()));
                    sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                    // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                    retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_FM_UPD_ASSIGNEDTO_SEQ, sqlParams);
                }
                //else if (rblAssign.SelectedValue == "0")
                //{


                //    foreach (GridViewRow row in gdv_list.Rows)
                //    {
                //        sequencer = Convert.ToInt32(row.Cells[0].Text);
                //        sqlParams.Add(new OleDbParameter("V_SEQUENCER", sequencer));
                //        sqlParams.Add(new OleDbParameter("V_ASSIGNEDTO", company));
                //        sqlParams.Add(new OleDbParameter("V_INSPECTIONDUEDATE", txtInspDueDt.Text.Trim()));
                //        sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                //        // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                //        retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_FM_UPD_ASSIGNEDTO_SEQ, sqlParams);
                //    }
                //}
                
                

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                //javascript function call to update controls
                string jsFunc = "LoadDetailsAssignStatus(" + sequencer + ")";
                ScriptManager.RegisterStartupScript(this.Page, Page.GetType(), "myJsFn", jsFunc, true);

                //Rebind the gridtable after updation
                string func = "ReloadGridTable()";
                ScriptManager.RegisterStartupScript(this.Page, Page.GetType(), "myJsFn1", func, true);
                
                bindIssueAssignedTo();
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Update successful')", true);

               
            }
        }

        [WebMethod]
        public static int UpdateAllAssign(string Sequencer, int Company, string InspDueDt, int Crew)
        {
            int sequencer = 0;
            int retVal = 0;

            string[] values = Sequencer.Split(',');
            for (int i = 0; i < values.Length; i++)
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sequencer = Convert.ToInt32(values[i].Trim());
                sqlParams.Add(new OleDbParameter("V_SEQUENCER", sequencer));
                sqlParams.Add(new OleDbParameter("V_ASSIGNEDTO", Company));
                sqlParams.Add(new OleDbParameter("V_CREW_ID", Crew));
                sqlParams.Add(new OleDbParameter("V_INSPECTIONDUEDATE", InspDueDt));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam("Vegdbo.SP_FM_UPD_ASSIGNEDTO_SEQ", sqlParams);
            }
            return retVal;
        }

        protected void btnReset_Click(object sender, EventArgs e)
        {
            ddlAssignedTo.ClearSelection();
            txtInspDueDt.Text = "";
        }

        protected void btnStatusReset_Click(object sender, EventArgs e)
        {
            //dllCurrentStatus.ClearSelection();
            lblCurrentStatus.Text = "";
            ddlUpdatedStatus.ClearSelection();
        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            int sequencer = 0;
            int retVal = 0;
            int updstatus = 0;

            if (gdv_list.Rows.Count <= 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Please Search to Assign Status.')", true);
                return;
            }

            try
            {
                updstatus = Convert.ToInt32(ddlUpdatedStatus.SelectedValue);
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                if (hfSequencer.Value != "" && rblStatus.SelectedValue == "1")
                {
                    sequencer = Convert.ToInt32(hfSequencer.Value);
                    sqlParams.Add(new OleDbParameter("V_SEQUENCER", sequencer));
                    sqlParams.Add(new OleDbParameter("V_ISSUE_STATUS_ID", updstatus));
                    sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                    // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                    retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_FM_UPD_ISSUE_STATUS_SEQ, sqlParams);
                }
               // else if (rblStatus.SelectedValue == "0")
                //{
                    //for (int i = 0; i <= this.gdv_list.Rows.Count; i++)
                    //{

                    //    HtmlTable td = (HtmlTable)gdv_list.FindControl("sequencer");

                    //    if (td != null)
                    //    {
                    //        sequencer = Convert.ToInt32(gdv_list.Rows[i].Cells[0].Text);
                    //    }
                    //}

                    //for (int i = 0; i < gdv_list.Rows.Count; i++)
                    //{
                    //    for (int j = 0; j < gdv_list.Rows[i].Cells.Count; j++)
                    //    {
                    //        string cellValue = gdv_list.Rows[i].Cells[j].Text;
                    //        // do something here
                    //    }
                    //}

                    //foreach (GridViewRow row in gdv_list.Rows)
                    //{
                    //    sequencer = Convert.ToInt32(row.Cells[0].Text);
                    //    sqlParams.Add(new OleDbParameter("V_SEQUENCER", sequencer));
                    //    sqlParams.Add(new OleDbParameter("V_ISSUE_STATUS_ID", updstatus));
                    //    sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                    //    // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                    //    retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_FM_UPD_ISSUE_STATUS_SEQ, sqlParams);
                    //}
               // }
            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                //javascript function call to update controls
                string jsFunc = "LoadDetailsAssignStatus(" + sequencer + ")";
                ScriptManager.RegisterStartupScript(this.Page, Page.GetType(), "myJsFn", jsFunc, true);

                //Rebind the gridtable after updation
                string func = "ReloadGridTable()";
                ScriptManager.RegisterStartupScript(this.Page, Page.GetType(), "myJsFn1", func, true);

                bindIssueStatus();
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Update successful')", true);
            }
        }

        [WebMethod]
        public static int UpdateAllStatus(string Sequencer,int UpdStatus)
        {
            int sequencer = 0;
            int retVal = 0;
            
            string[] values = Sequencer.Split(',');
            for (int i = 0; i < values.Length; i++)
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sequencer = Convert.ToInt32(values[i].Trim());
                sqlParams.Add(new OleDbParameter("V_SEQUENCER", sequencer));
                sqlParams.Add(new OleDbParameter("V_ISSUE_STATUS_ID", UpdStatus));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam("Vegdbo.SP_FM_UPD_ISSUE_STATUS_SEQ", sqlParams);
            }
            return retVal;
        }

        protected void rblStatus_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (rblStatus.SelectedValue == "1") //1-Selected
            {
                SelectStatus();
            }
        }

        void SelectStatus()
        {
            int sequencer = 0;
            DataTable dt = new DataTable();
            try
            {
                if (hfSequencer.Value != "")
                {
                    sequencer = Convert.ToInt32(hfSequencer.Value);
                }
                List<OleDbParameter> OleDbParam = new List<OleDbParameter>();

                OleDbParam.Add(new OleDbParameter("V_SEQUENCER", sequencer));
                dt = DataAccessUtility.SelectDataTableViaStoreProcedureParam(m_SP_FM_SEL_ISSUE_STATUS_SEQ, OleDbParam);
                if (dt.Rows.Count > 0)
                {
                    lblCurrentStatus.Text = dt.Rows[0]["ISSUE_STATUS_NAME"].ToString();
                }
            }
            catch
            {
            }
            finally
            {
                dt.Clear();
                dt.Dispose();
            }
        }

        [WebMethod]
        public static string GetSelectStatus(int Sequencer)
        {
            string str = string.Empty;
            DataTable dt = new DataTable();
            try
            {
                List<OleDbParameter> OleDbParam = new List<OleDbParameter>();

                OleDbParam.Add(new OleDbParameter("V_SEQUENCER", Sequencer));
                dt = DataAccessUtility.SelectDataTableViaStoreProcedureParam("Vegdbo.SP_FM_SEL_ISSUE_STATUS_SEQ", OleDbParam);
                if (dt.Rows.Count > 0)
                {
                    str = dt.Rows[0]["ISSUE_STATUS_NAME"].ToString();
                }
            }
            catch
            {
            }
            finally
            {
                dt.Clear();
                dt.Dispose();
            }
            return str;
        }

        [WebMethod]
        public static string GetSelectedSequencer(string Sequencer)
        {
            DataSet ds = new DataSet();
            try
            {
                List<OleDbParameter> OleDbParam = new List<OleDbParameter>();

                OleDbParam.Add(new OleDbParameter("V_SEQUENCER", Sequencer));
                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam("Vegdbo.SP_FM_SEL_ISSUE_LIST", OleDbParam);

            }
            catch
            {
            }
            finally
            {
            }

            return ds.GetXml();

        }

        protected void ddlInspSubType_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindIssueType();
            //call javascript method to hide gridview columns
            //ScriptManager.RegisterStartupScript(this.Page, Page.GetType(), "text", "hideColumn()", true);
        }

        protected void ddlInspSubType_DataBound(object sender, EventArgs e)
        {
            bindIssueType();
            //call javascript method to hide gridview columns
            //ScriptManager.RegisterStartupScript(this.Page, Page.GetType(), "text", "hideColumn()", true);
        }

        protected void ddlIssueType_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindIssueSubType();
            //call javascript method to hide gridview columns
            //ScriptManager.RegisterStartupScript(this.Page, Page.GetType(), "text", "hideColumn()", true);
        }

        protected void ddlIssueType_DataBound(object sender, EventArgs e)
        {
            bindIssueSubType();
            //call javascript method to hide gridview columns
            //ScriptManager.RegisterStartupScript(this.Page, Page.GetType(), "text", "hideColumn()", true);
        }

        void ClearLables()
        {
            lblSCEGNote.Text = "";
            lblFlagID.Text = "";
            lblContractor.Text = "";
            lblContractorNote.Text = "";
            lblAssignedTo.Text = "";
            lblAssignedDate.Text = "";
            lblTreeCnt.Text = "";
            lblLastUpdatedBy.Text = "";
            lblLastUpdatedOn.Text = "";
        }

        protected void ddlIssueSubType_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindIssueStatus();
            //call javascript method to hide gridview columns
            //ScriptManager.RegisterStartupScript(this.Page, Page.GetType(), "text", "hideColumn()", true);
        }

        protected void ddlIssueSubType_DataBound(object sender, EventArgs e)
        {
            bindIssueStatus();
        }

        protected void ddlIssueStatus_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindIssueAssignedTo();
        }

        protected void ddlIssueStatus_DataBound(object sender, EventArgs e)
        {
            bindIssueAssignedTo();
        }

        protected void ddlAssignedTo_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindCrew();
        }

        protected void ddlAssignedTo_DataBound(object sender, EventArgs e)
        {
            bindCrew();

        }

        protected void btnResetAll_Click(object sender, EventArgs e)
        {
            ClearLables();
            bindIssueSubType();
            bindIssueStatus();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindWorkArea();
        }

        protected void ddlWorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindInspectionGroup();
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            bindWorkArea();
        }

        protected void ddlWorkArea_DataBound(object sender, EventArgs e)
        {
            bindInspectionGroup();
        }

       
        //protected void ddlInspectionGroup_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    string inspGrp=ddlInspectionGroup.SelectedValue;
        //    if (inspGrp != "0")
        //    {
        //        ddlInspSubType.SelectedValue = inspGrp;
        //        ddlInspSubType.Enabled = false;
        //    }
        //    else
        //    {
        //        ddlInspSubType.Enabled = true;
        //    }
        //    bindIssueType();
        //    UpdatePanel1.Update();
        //}

        //protected void chkFilter_CheckedChanged(object sender, EventArgs e)
        //{
        //    if (chkFilter.Checked)
        //    {
        //        ddlInspectionGroup.Enabled = true;
        //    }
        //    else
        //    {
        //        Page.ClientScript.RegisterStartupScript(this.GetType(), "CallMyFunction", "InspectionGroupChange()", true);
        //        ddlInspectionGroup.SelectedValue = "0";
        //        ddlInspectionGroup.Enabled = false;
        //        ddlInspSubType.Enabled = true;
        //        UpdatePanel1.Update();

        //    }
        //}

       
 
    }
}