﻿using DataAccess;
using System;
using System.Collections.Generic;
using System.Data.OleDb;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace VMT
{
    public partial class FlightIssueHistory : System.Web.UI.Page
    {
        string m_SP_FRH_SELECT_FLIGHT_TYPE = Properties.Settings.Default.SP_FRH_SELECT_FLIGHT_TYPE;
        string m_SP_FRH_SELECT_FLIGHT_YEAR = Properties.Settings.Default.SP_FRC_SELECT_FLIGHT_YEAR;
        string m_SP_FRH_FLIGHT_RECORDS_REP = Properties.Settings.Default.SP_FRH_FLIGHT_RECORDS_REP;
      

        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Flight Status Summary ";
        protected void Page_Load(object sender, EventArgs e)
        {
           

            if (!Page.IsPostBack)
            {

                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                bindFlightType();
                bindFlightYear();
             //   BindGrid();

            }
        }
        void bindFlightType()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FRH_SELECT_FLIGHT_TYPE, ddlFlightType);
            }
            catch
            {
            }
        }
        void bindFlightYear()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FRH_SELECT_FLIGHT_YEAR, ddlFlightYear);
            }
            catch
            {
            }
        }
        private void BindGrid()
        {
            //gdv_FlightReport.DataBind();
            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();

                OleDbParams.Add(new OleDbParameter("v_flight_year_id", Convert.ToInt32(ddlFlightYear.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("v_flight_type_id", Convert.ToInt32(ddlFlightType.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("v_Report_type", Convert.ToInt32(ddlReportType.SelectedValue)));
                DataAccessUtility.BindGridViewViaProcedureWithParameter(m_SP_FRH_FLIGHT_RECORDS_REP, OleDbParams, gdv_FlightReport);
                gdv_FlightReport.SelectedIndex = -1;                  
            }
            catch
            {
            }
        }
        //protected void ddlFlightType_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    BindGrid();
        //}

        //protected void ddlFlightYear_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    BindGrid();
        //}

        protected void btnView_Click(object sender, EventArgs e)
        {
            BindGrid();
        }

        //protected void gdv_FlightReport_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    string flightid = (gdv_FlightReport.SelectedRow.FindControl("lbl_FLIGHT_RCD_ID") as Label).Text;
        //    BindIssueHistoryDetailGrid(Convert.ToInt32(flightid));
        //}

        //void BindIssueHistoryDetailGrid(int flight_record_id)
        //{
        //    try
        //    {
        //        //List<OleDbParameter> OledbParams = new List<OleDbParameter>();
        //        //OledbParams.Add(new OleDbParameter("V_PAYMENT_ID", flight_record_id));
        //        //DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SELECT_PAYMENT_DETAIL, OledbParams, gdv_FlightDetail);
        //    }
        //    catch
        //    {
        //    }
        //}



    }
}