﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;

namespace VMT
{
    public partial class EventCode : System.Web.UI.Page
    {
        string m_SP_VDM_SELECT_BUSINESS_UNIT = Properties.Settings.Default.SP_VDM_SELECT_BUSINESS_UNIT;
        string m_SP_SELECT_ALL_DISTRICT = Properties.Settings.Default.SP_SELECT_ALL_DISTRICT;
        string m_SP_VDM_EVENT_CODE_INS_UPD = Properties.Settings.Default.SP_VDM_EVENT_CODE_INS_UPD;
        string m_SP_VDM_SELECT_EVTCODE = Properties.Settings.Default.SP_VDM_SELECT_EVTCODE;
        string m_SP_VDM_EVENT_CODE_DETAIL = Properties.Settings.Default.SP_VDM_EVENT_CODE_DETAIL;
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "EventCode";

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                //userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                //if (userRole == "0")
                //{
                //    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                //}

                BindGrid();
                BindBusinessUnit();
                BindDistrict();
                btn_create.Visible = false;
                btn_delete.Visible = false;
            }
        }

        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_BUSINESS_UNIT, ddl_BUnit);
            }
            catch
            {
            }
        }

        void BindDistrict()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SELECT_ALL_DISTRICT, ddl_District);
            }
            catch
            {
            }
        }

        protected void btn_add_Click(object sender, EventArgs e)
        {
            if (btn_add.Text == "Add New")
            {
                AddUpdate("INSERT");
            }
            else if (btn_add.Text == "Update")
            {
                AddUpdate("UPDATE");
            }
        }

        private void AddUpdate(string strOperation)
        {


            if (txt_EventCode.Text.Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Event code could not be blank!')", true);
                txt_EventCode.Focus();
                return;
            }

            try
            {
                if (txt_ProjectTrimDate.Text.Trim().Length > 0)
                     Convert.ToDateTime(txt_ProjectTrimDate.Text.ToString().Trim());
            }
            catch
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Invalida date!')", true);
                //txt_ProjectTrimDate.Text = "";
                return;
            }

            int EventCode_id = 0;
            if (strOperation == "INSERT")
            {
                EventCode_id = 0;
            }
            else
            {
                EventCode_id = Int32.Parse(hdn_keyid.Value);
            }

            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", EventCode_id));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE", txt_EventCode.Text.Trim().ToString()));
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_BUnit.SelectedValue.ToString()));
                sqlParams.Add(new OleDbParameter("V_PROJ_TRIM_DATE", txt_ProjectTrimDate.Text.Trim().ToString()));//Convert.ToDateTime(txt_ProjectTrimDate.Text.Trim()).ToString("MM/DD/YYYY HH:MI:SS AM")));
                sqlParams.Add(new OleDbParameter("V_DISTRICT_ID", ddl_District.SelectedValue.ToString()));

                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_EVENT_CODE_INS_UPD, sqlParams);
             
            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {

                clearfields();
                BindGrid();

                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);
                return;
            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Event code already exists')", true);
                return;
            }

        }



        private void BindGrid()
        {
            try
            {
                DataAccessUtility.BindGridViewViaProcedure(m_SP_VDM_SELECT_EVTCODE, gdv_EventCode);
                gdv_EventCode.SelectedIndex = -1;
            }
            catch
            {
            }
        }

        void clearfields()
        {
            btn_create.Visible = false;
            btn_delete.Visible = false;
            hdn_keyid.Value = "";
            btn_add.Text = "Add New";
            txt_EventCode.Text = "";
            txt_ProjectTrimDate.Text = "";
            ddl_BUnit.SelectedIndex = 0;
            ddl_District.SelectedIndex = 0;
        }

        protected void gdv_EventCode_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
        {
            GridViewRow row = gdv_EventCode.Rows[e.NewSelectedIndex];
            hdn_keyid.Value = row.Cells[1].Text;
            btn_add.Text = "Update";
            btn_create.Visible = true;
            btn_delete.Visible = true;
            getdetail();
        }

        void getdetail()
        {
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            try
            {
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", hdn_keyid.Value));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_VDM_EVENT_CODE_DETAIL, OleDbParams);
                ddl_BUnit.SelectedValue = ds.Tables[0].Rows[0]["BUSINESS_UNIT_ID"].ToString();
                ddl_District.SelectedValue = ds.Tables[0].Rows[0]["DISTRICT_ID"].ToString();
                txt_EventCode.Text = ds.Tables[0].Rows[0]["EVENT_CODE"].ToString();
                //txt_ProjectTrimDate.Text = Convert.ToDateTime(ds.Tables[0].Rows[0]["PROJ_TRIM_DATE"].ToString()).ToString("mm/dd/yy");
                txt_ProjectTrimDate.Text = ds.Tables[0].Rows[0]["PROJ_TRIM_DATE"].ToString();
            }
            catch
            {
                txt_ProjectTrimDate.Text = "";
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }

        protected void btn_reset_Click(object sender, EventArgs e)
        {
            if (hdn_keyid.Value == "")
            {
                clearfields();
            }

            else
            {
                getdetail();
            }
        }

        protected void btn_delete_Click(object sender, EventArgs e)
        {
            AddUpdate("DELETE");
        }

        protected void btn_create_Click(object sender, EventArgs e)
        {
            clearfields();
        }

        protected void gdv_EventCode_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[1].Visible = false; // hides the first column
        }
    }
}