﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using DataAccess;
using System.Data.OleDb;
using System.Data;

namespace VMT
{
    public partial class EC_WA : System.Web.UI.Page
    {
        string m_SP_SELECT_BUSINESS_UNIT = Properties.Settings.Default.SP_SELECT_BUSINESS_UNIT;
        string m_SP_VDM_SELECT_YR_MOVE_CYCLE = Properties.Settings.Default.SP_VDM_SELECT_YR_MOVE_CYCLE;

        string m_SP_SELECT_DISTRICT_EC_WA = Properties.Settings.Default.SP_SELECT_DISTRICT_EC_WA;
        string m_SP_VDM_SELECT_EC_EC_WA = Properties.Settings.Default.SP_VDM_SELECT_EC_EC_WA;
        string m_SP_VDM_SELECT_WA_EC_WA = Properties.Settings.Default.SP_VDM_SELECT_WA_EC_WA;
        string m_SP_VDM_EC_WA_INS_UPD = Properties.Settings.Default.SP_VDM_EC_WA_INS_UPD;
        string m_SP_VDM_SELECT_EVENT_CODE_DET = Properties.Settings.Default.SP_VDM_SELECT_EVENT_CODE_DET;
        string m_SP_VDM_SELECT_WA_DESC_EC_WA = Properties.Settings.Default.SP_VDM_SELECT_WA_DESC_EC_WA;
        string m_SP_VDM_SELECT_EC_DETAILS_EC_WA = Properties.Settings.Default.SP_VDM_SELECT_EC_DETAILS_EC_WA;
        string m_SP_VDM_SELECT_EXIST_EVENT_CODE = Properties.Settings.Default.SP_VDM_SELECT_EXIST_EVENT_CODE;
        string m_SP_SPR_SELECT_WA_DESC_EC_WA = Properties.Settings.Default.SP_SPR_SELECT_WA_DESC_EC_WA;
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Event Code Maintenance";

        protected void Page_Load(object sender, EventArgs e)
        {
            

            if (!Page.IsPostBack)
            {
                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    //System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }
                
                //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
                //string userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
                //if (userRole == "Edit")
                //{
                //    btnSubmit.Visible = true;
                //}
                //else
                //{
                //    btnSubmit.Visible = false;
                //}

                bindBusinessUnit();
                //BindYear();
                bindDistrict();
                BindCycle(ddlCycle);
                //BindCycle(ddlSprayCycle);
                BindYear(ddlCycleYr);
                //BindYear(ddlSprayCycleYr);
                ddlCycleYr.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                //ddlSprayCycleYr.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                BindYear(ddlTrimYr);
                //BindYear(ddlSprayTrimYr);
                ddlTrimYr.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                //ddlSprayTrimYr.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                CalculateTrimYearTgt();
                //btnDelete.Visible = false;
                BindNewText(ddlEventCode);
                BindNewText(ddlWAEventCode);
                BindNewText(ddlWorkArea);

                BindEventCode();
                BindWAEventCode();
            }
        }

        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SELECT_BUSINESS_UNIT, ddlBunit);
            }
            catch
            {
            }
        }

        void bindDistrict()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SELECT_DISTRICT_EC_WA, ddlDistrict);
            }
            catch
            {
            }
        }

        void BindCycle(DropDownList ddlCycle)
        {
            ddlCycle.Items.Clear();
            ddlCycle.Items.AddRange(Enumerable.Range(1, 9).Select(e => new ListItem(e.ToString())).ToArray());
            ddlCycle.SelectedValue = Properties.Settings.Default.SELECTED_CYCLE;
        }

        void BindYear(DropDownList ddlYr)
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_YR_MOVE_CYCLE, ddlYr);
            }
            catch
            {
            }
        }

        void BindEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBunit.SelectedValue);
                //V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);

                if (rblEventCode.SelectedValue != "0")
                {
                    List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                    OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                    OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                    DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_EC_EC_WA, OledbParams, ddlEventCode);
                }
            }
            catch
            {
            }
        }

        void BindWAEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBunit.SelectedValue);
                //V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);

               
                    List<OleDbParameter> OledbParam = new List<OleDbParameter>();
                    OledbParam.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                    OledbParam.Add(new OleDbParameter("V_YEAR", V_YEAR));
                    DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_EC_EC_WA, OledbParam, ddlWAEventCode);
            }
            catch
            {
            }
        }

        void BindWorkArea()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBunit.SelectedValue);
                //V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlWAEventCode.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_WA_EC_WA, OledbParams, ddlWorkArea);
            }
            catch
            {
            }
        }

        protected void ddlWAEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindWorkArea();
        }

        protected void ddlCycle_SelectedIndexChanged(object sender, EventArgs e)
        {
            CalculateTrimYearTgt();
        }

        protected void ddlCycleYr_SelectedIndexChanged(object sender, EventArgs e)
        {
            CalculateTrimYearTgt();
        }

        void CalculateTrimYearTgt()
        {
            txtFTYT.Text = (Int32.Parse(ddlCycleYr.SelectedItem.Text) + Int32.Parse(ddlCycle.SelectedValue)).ToString();
            //txtSprayFTYT.Text = (Int32.Parse(ddlSprayCycleYr.SelectedItem.Text) + Int32.Parse(ddlSprayCycle.SelectedValue)).ToString();
        }


        protected void rblEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (rblEventCode.SelectedValue == "0")
            {
                ddlEventCode.ClearSelection();
                ddlEventCode.Enabled = false;
                txtEventCode.Text = "";
                txtEventDescription.Text = "";
                ddlDistrict.ClearSelection();
                txtEventCode.Enabled = true;

                BindNewText(ddlEventCode);
               
                ddlCycle.Enabled = true;
                ddlCycleYr.Enabled = true;
                txtFTYT.Enabled = true;
                txtSectionCode.Enabled = true;
                txtWADescription.Enabled = true;
                pnlSectionCode.Visible = false;
                txtNewSectionCode.Text = "";
                txtNewWADescription.Text = "";
                gdv_WA_Company.Visible = false;
            }
            else
            {
                BindEventCode();
                ddlEventCode.Enabled = true;
                txtEventCode.Enabled = true;
                txtEventCode.Text = "";
                txtEventDescription.Text = "";
                ddlDistrict.ClearSelection();
            }

            if (rblEventCode.SelectedValue == "0" && rblWorkArea.SelectedValue == "0")
            {
                BindNewText(ddlWAEventCode);
                BindNewText(ddlWorkArea);
            }
        }

        protected void rblWorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (rblWorkArea.SelectedValue == "0")
            {
                //spnlWAEventCode.Visible = false;
                ddlWAEventCode.ClearSelection();
                ddlWorkArea.ClearSelection();
                ddlWAEventCode.Enabled = false;
                ddlWorkArea.Enabled = false;

                BindNewText(ddlWAEventCode);
                BindNewText(ddlWorkArea);
                
                ddlCycle.Enabled = true;
                ddlCycleYr.Enabled = true;
                txtFTYT.Enabled = true;
                txtSectionCode.Enabled = true;
                txtWADescription.Enabled = true;
                pnlSectionCode.Visible = false;
                txtSectionCode.Text = "";
                txtWADescription.Text = "";
                txtNewSectionCode.Text = "";
                txtNewWADescription.Text = "";
                chkSplit.Visible = false;
                chkSplit.Checked = false;
                
                if (ddlEventCode.SelectedIndex > 0)
                {
                    BindWAEventCode();
                    ddlWAEventCode.SelectedValue = ddlEventCode.SelectedValue;
                }
            }
            else if (rblWorkArea.SelectedValue == "1")
            {
                //if (rblEventCode.SelectedValue == "0")
                //{
                    BindWAEventCode();
                //}
                if (ddlEventCode.SelectedIndex > 0)
                {
                    ddlWAEventCode.SelectedValue = ddlEventCode.SelectedValue;
                }
                pnlWAEventCode.Visible = true;
                txtSectionCode.Text = "";
                txtWADescription.Text = "";
                txtNewSectionCode.Text = "";
                txtNewWADescription.Text = "";
                BindWorkArea();
                ddlWAEventCode.Enabled = true;
                ddlWorkArea.Enabled = true;
            }
            else
            {
            }
        }              

        void BindNewText(DropDownList ddl)
        {
            Dictionary<string, string> EC = new Dictionary<string, string>();
            EC.Add("-1", "-New-");
            ddl.DataSource = EC;
            ddl.DataValueField = "Key";
            ddl.DataTextField = "Value";
            ddl.DataBind();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindEventCodeTextBox();
            BindEventCodeDetails();
            //if (ddlEventCode.SelectedIndex > 0)
            //{
            //    ddlWAEventCode.SelectedValue = ddlEventCode.SelectedValue;
            //    BindWorkArea();
            //}
        }

        protected void btnSubmit_Click(object sender, EventArgs e)
        {
            string retVal = string.Empty;
            int eventCode = 0;
            int workArea = 0;
            int distId = 0;
            if (ddlDistrict.SelectedIndex > 0)
            {
                distId = Convert.ToInt32(ddlDistrict.SelectedValue.ToString());
            }

            if (txtEventCode.Text.Trim().Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Event code could not be blank!')", true);
                txtEventCode.Focus();
                return;
            }
            //if (txtSectionCode.Text.Trim().Length == 0)
            //{
            //    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Section code could not be blank!')", true);
            //    txtSectionCode.Focus();
            //    return;
            //}
            if ((rblWorkArea.SelectedValue.Trim() == "0" || (rblWorkArea.SelectedValue.Trim() == "1" && ddlWAEventCode.SelectedIndex > 0)) && txtSectionCode.Text.Trim().Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Section code could not be blank!')", true);
                txtSectionCode.Focus();
                return;
            }
            if (txtNewSectionCode.Text.Trim().Length == 0 && chkSplit.Checked)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('New section code could not be blank!')", true);
                txtNewSectionCode.Focus();
                return;
            }
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Int32.Parse(ddlBunit.SelectedValue.Trim())));
                sqlParams.Add(new OleDbParameter("V_EC_OPTION", Int32.Parse(rblEventCode.SelectedValue.Trim())));
                sqlParams.Add(new OleDbParameter("V_WA_OPTION", Int32.Parse(rblWorkArea.SelectedValue.Trim())));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", Int32.Parse(ddlEventCode.SelectedValue.Trim())));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE", txtEventCode.Text.Trim().ToUpper()));
                sqlParams.Add(new OleDbParameter("V_EVENT_DESCRIPTION", txtEventDescription.Text.Trim()));
                //sqlParams.Add(new OleDbParameter("V_TRIM_DATE", Convert.ToDateTime(txtTrimDate.Text.Trim())));
                sqlParams.Add(new OleDbParameter("V_DISTRICT", distId));
                sqlParams.Add(new OleDbParameter("V_WA_EVENT_CODE_ID", Int32.Parse(ddlWAEventCode.SelectedValue.Trim())));
                sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", Int32.Parse(ddlWorkArea.SelectedValue.Trim())));
                if(chkSplit.Checked)
                    sqlParams.Add(new OleDbParameter("V_SPLIT", "Y"));
                else
                    sqlParams.Add(new OleDbParameter("V_SPLIT", "N"));
                sqlParams.Add(new OleDbParameter("V_CYCLE", Int32.Parse(ddlCycle.SelectedValue.Trim())));
                sqlParams.Add(new OleDbParameter("V_CYCLE_YEAR", Int32.Parse(ddlCycleYr.SelectedValue.Trim())));
                sqlParams.Add(new OleDbParameter("V_TRIM_YEAR", Int32.Parse(ddlTrimYr.SelectedValue.Trim())));
                sqlParams.Add(new OleDbParameter("V_FTYT", Int32.Parse(txtFTYT.Text.Trim())));
                sqlParams.Add(new OleDbParameter("V_SECTION_CODE", txtSectionCode.Text.Trim().ToUpper()));
                sqlParams.Add(new OleDbParameter("V_WORKAREA_DESCRIPTION", txtWADescription.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_NEW_SECTION_CODE", txtNewSectionCode.Text.Trim().ToUpper()));
                sqlParams.Add(new OleDbParameter("V_NEW_WORKAREA_DESCRIPTION", txtNewWADescription.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_TRANSACTION_COMMENT", txtComment.Text.Trim()));

                //sqlParams.Add(new OleDbParameter("V_SPRAY_CYCLE", Int32.Parse(ddlSprayCycle.SelectedValue.Trim())));
                //sqlParams.Add(new OleDbParameter("V_SPRAY_CYCLE_YEAR", Int32.Parse(ddlSprayCycleYr.SelectedValue.Trim())));
                //sqlParams.Add(new OleDbParameter("V_SPRAY_TRIM_YEAR", Int32.Parse(ddlSprayTrimYr.SelectedValue.Trim())));
                //sqlParams.Add(new OleDbParameter("V_SPRAY_FTYT", Int32.Parse(txtSprayFTYT.Text.Trim())));

                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsUpdDelViaStoreProcedureParam(m_SP_VDM_EC_WA_INS_UPD, sqlParams);
                if (retVal == "5")
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('This Section Code exists.')", true);
                    if(chkSplit.Checked)
                    {
                        if (rblWorkArea.SelectedValue != "1")
                        {
                            txtSectionCode.Text = "";
                        }
                        txtNewSectionCode.Text = "";
                        txtNewSectionCode.Focus();
                    }
                    else
                    {
                        txtSectionCode.Text = "";
                        txtNewSectionCode.Text = "";
                        txtSectionCode.Focus();
                    }
                }
                else if (retVal != "")
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Event code/Work area saved successfully.')", true);
                    string[] EventCodeWorkAreas = retVal.Split('-');

                    eventCode = Convert.ToInt32(EventCodeWorkAreas[0]);
                    workArea = Convert.ToInt32(EventCodeWorkAreas[1]);

                    rblEventCode.SelectedValue = "1";
                    rblWorkArea.SelectedValue = "1";
                    BindEventCode();
                    ddlEventCode.SelectedValue = eventCode.ToString();
                    BindWAEventCode();
                    ddlWAEventCode.SelectedValue = eventCode.ToString();
                    //BindWAEventCode();
                    BindWorkArea();
                    ddlWorkArea.SelectedValue = workArea.ToString();

                    ddlWAEventCode.Enabled = true;
                    ddlWorkArea.Enabled = true;
                    txtComment.Text = "";
                    BindEventCodeDetails();
                }
            }
            catch { }
            finally
            {
            }
        }

        void BindEventCodeTextBox()
        {
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));

                DataSet ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_VDM_SELECT_EVENT_CODE_DET, OledbParams);
                txtEventCode.Text = ds.Tables[0].Rows[0]["EVENT_CODE"].ToString();
                if (ds.Tables[0].Rows[0]["event_code_description"].ToString() != "")
                {
                    txtEventDescription.Text = ds.Tables[0].Rows[0]["event_code_description"].ToString();
                }
                if (ds.Tables[0].Rows[0]["DISTRICT_ID"].ToString() != "")
                {
                    ddlDistrict.SelectedValue = ds.Tables[0].Rows[0]["DISTRICT_ID"].ToString();
                }
            }
            catch
            {
            }
        }

        void BindWorkAreaDescription()
        {
            int V_WORK_AREA_ID = 0;
            try
            {
                V_WORK_AREA_ID = Convert.ToInt32(ddlWorkArea.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));

                DataSet ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_VDM_SELECT_WA_DESC_EC_WA, OledbParams);
                txtSectionCode.Text = ds.Tables[0].Rows[0]["old_section_code"].ToString();
                txtWADescription.Text = ds.Tables[0].Rows[0]["work_area_description"].ToString();
                ddlCycle.SelectedValue = ds.Tables[0].Rows[0]["trim_cycle"].ToString();
                ddlCycleYr.SelectedValue = ds.Tables[0].Rows[0]["SYSTEM_ASSIGNED_YEAR"].ToString();
                ddlTrimYr.SelectedValue = ds.Tables[0].Rows[0]["trim_year_target"].ToString();
                //txtFTYT.Text = ds.Tables[0].Rows[0]["work_area_description"].ToString();

                List<OleDbParameter> OledbParams1 = new List<OleDbParameter>();
                OledbParams1.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                DataSet ds1 = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SPR_SELECT_WA_DESC_EC_WA, OledbParams1);
                //ddlSprayCycle.SelectedValue = ds1.Tables[0].Rows[0]["spray_cycle"].ToString();
                //ddlSprayCycleYr.SelectedValue = ds1.Tables[0].Rows[0]["SYSTEM_ASSIGNED_YEAR"].ToString();
                //ddlSprayTrimYr.SelectedValue = ds1.Tables[0].Rows[0]["spray_year_target"].ToString();

                CalculateTrimYearTgt();
            }
            catch
            {
            }
        }

        void BindEventCodeDetails()
        {
            int V_EVENT_CODE_ID = 0;
            try
            {
                if (rblEventCode.SelectedValue == "0")
                    gdv_WA_Company.Visible = false;
                else
                    gdv_WA_Company.Visible = true;

                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));

                DataSet ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_VDM_SELECT_EC_DETAILS_EC_WA, OledbParams);
                gdv_WA_Company.DataSource = ds;
                gdv_WA_Company.DataBind();
            }
            catch
            {
            }
        }

        protected void chkSplit_CheckedChanged(object sender, EventArgs e)
        {
            if (chkSplit.Checked)
            {
                ddlCycle.Enabled = false;
                ddlCycleYr.Enabled = false;
                txtFTYT.Enabled = false;
                txtSectionCode.Enabled=false;
                txtWADescription.Enabled = false;
                pnlSectionCode.Visible = true;
            }
            else
            {
                ddlCycle.Enabled = true;
                ddlCycleYr.Enabled = true;
                txtFTYT.Enabled = true;
                txtSectionCode.Enabled = true;
                txtWADescription.Enabled = true;
                pnlSectionCode.Visible = false;
                txtNewSectionCode.Text = "";
                txtNewWADescription.Text = "";
            }
        }

        protected void ddlWorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            txtSectionCode.Text = "";
            txtWADescription.Text = "";          
            txtFTYT.Text = "";


            BindWorkAreaDescription();
            if (ddlWorkArea.SelectedIndex > 0)
            {
                chkSplit.Visible = true;
            }
            else
            {
                chkSplit.Visible = false;
                chkSplit.Checked = false;
            }
        }

        protected void txtEventCode_TextChanged(object sender, EventArgs e)
        {
            string V_EVENT_CODE;
            try
            {
                V_EVENT_CODE = txtEventCode.Text.Trim().ToUpper();
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE", V_EVENT_CODE));

                int result = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_SELECT_EXIST_EVENT_CODE, OledbParams);
                if (result > 0)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('This event code exists.')", true);
                    txtEventCode.Text = "";
                    txtEventCode.Focus();
                }
            }
            catch
            {
            }
        }

        protected void ddlBunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            rblEventCode.SelectedValue = "0";
            rblWorkArea.SelectedValue = "0";
            ddlEventCode.ClearSelection();
            BindNewText(ddlEventCode);
            txtEventCode.Text = "";
            txtEventDescription.Text = "";
            ddlDistrict.ClearSelection();
            ddlWAEventCode.ClearSelection();
            ddlWorkArea.ClearSelection();
            BindNewText(ddlWAEventCode);
            BindNewText(ddlWorkArea);
            txtWADescription.Text = "";
            txtSectionCode.Text = "";
            chkSplit.Checked = false;
            chkSplit.Visible = false;
            txtNewSectionCode.Text = "";
            txtNewWADescription.Text = "";
            BindEventCodeDetails();

            pnlSectionCode.Visible = false;
            ddlCycle.Enabled = true;
            ddlCycleYr.Enabled = true;
            txtFTYT.Enabled = true;
            txtSectionCode.Enabled = true;
            txtWADescription.Enabled = true;
            ddlCycleYr.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
            CalculateTrimYearTgt();
            BindCycle(ddlCycle);
            //Response.Redirect(Request.Url.ToString());
        }

        protected void ddlSprayCycleYr_SelectedIndexChanged(object sender, EventArgs e)
        {
            CalculateTrimYearTgt();
        }

        protected void ddlSprayCycle_SelectedIndexChanged(object sender, EventArgs e)
        {
            CalculateTrimYearTgt();
        }

       
    }
}