﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;

namespace VMT
{
    public partial class Crew_Company : System.Web.UI.Page
    {
        string m_SP_CC_SELECT_COMPANY = Properties.Settings.Default.SP_CC_SELECT_COMPANY;
        string m_SP_CC_CREW_COMPANY_INS_UPD = Properties.Settings.Default.SP_CC_CREW_COMPANY_INS_UPD;
        string m_SP_CC_SELECT_CREW_COMPANY = Properties.Settings.Default.SP_CC_SELECT_CREW_COMPANY;
        string m_SP_CC_SEL_COMPANY_CREW_DETAIL = Properties.Settings.Default.SP_CC_SEL_COMPANY_CREW_DETAIL;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Crew Company";

        protected void Page_Load(object sender, EventArgs e)
        {
           

            if (!Page.IsPostBack)
            {
                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                hdn_role.Value = userRole;
                //if (userRole == "Edit")
                //{
                //    btn_add.Visible = true;
                //}
                //else
                //{
                //    btn_add.Visible = false;
                //}

                bindCompany();
                //  bindGrid();
                btn_create.Visible = false;
                btn_delete.Visible = false;
            }
        }
        void bindCompany()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_CC_SELECT_COMPANY, ddl_c0mpany);
            }
            catch
            {
            }

        }
        void clearfields()
        {
            btn_create.Visible = false;
            btn_delete.Visible = false;
            hdn_keyid.Value = "";
            btn_add.Text = "Add New";
            txt_EmployeeName.Text = "";
            txt_txtempemailid.Text = "";
           
            // ddl_c0mpany.SelectedIndex = -1;
        }
        void getdetail()
        {
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            try
            {
                OleDbParams.Add(new OleDbParameter("V_CREW_ID", hdn_keyid.Value));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_CC_SEL_COMPANY_CREW_DETAIL, OleDbParams);


                //bind the fields of contact information
                txt_EmployeeName.Text = ds.Tables[0].Rows[0]["CREW_NAME"].ToString();
                txt_txtempemailid.Text = ds.Tables[0].Rows[0]["CREW_DESCRIPTION"].ToString();                
                ddl_c0mpany.SelectedValue = ds.Tables[0].Rows[0]["COMPANY_ID"].ToString();
            }
            catch
            {
            }
        }

        private void AddUpdate(string strOperation)
        {


            if (txt_EmployeeName.Text.Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Employee name could not be blank!')", true);
                txt_EmployeeName.Focus();
                return;
            }
            int employee_id = 0;
            if (strOperation == "INSERT")
            {
                employee_id = 0;
            }
            else
            {
                employee_id = Int32.Parse(hdn_keyid.Value);
            }

            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", ddl_c0mpany.SelectedValue.ToString()));
                sqlParams.Add(new OleDbParameter("V_CREW_ID", employee_id));
                sqlParams.Add(new OleDbParameter("V_CREW_NAME", txt_EmployeeName.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_CREW_DESCRIPTION", txt_txtempemailid.Text.Trim()));
               

                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_CC_CREW_COMPANY_INS_UPD, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {

                clearfields();
                bindGrid();

                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);
                return;
            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('CREW already exists')", true);
                return;
            }

        }
        private void bindGrid()
        {

            //DataAccessUtility.BindGridViewViaProcedure("SP_SELECT_COMPANY_EMP", gdv_Company);
            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                OleDbParams.Add(new OleDbParameter("V_COMPANY_ID", ddl_c0mpany.SelectedValue));

                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_CC_SELECT_CREW_COMPANY, OleDbParams, gdv_Company);
                gdv_Company.SelectedIndex = -1;
            }
            catch
            {
            }
        }
        protected void btn_add0_Click(object sender, EventArgs e)
        {
            if (btn_add.Text == "Add New")
            {
                AddUpdate("INSERT");
            }
            else if (btn_add.Text == "Update")
            {
                AddUpdate("UPDATE");
            }
        }

        protected void btn_delete_Click(object sender, EventArgs e)
        {
            AddUpdate("DELETE");
        }

        protected void btn_reset_Click(object sender, EventArgs e)
        {
            if (hdn_keyid.Value == "")
            {
                clearfields();
            }

            else
            {
                getdetail();
            }
        }

        protected void btn_create_Click(object sender, EventArgs e)
        {
            clearfields();
        }

        protected void gdv_Company_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
        {
            GridViewRow row = gdv_Company.Rows[e.NewSelectedIndex];
            hdn_keyid.Value = row.Cells[1].Text;

            if (hdn_role.Value == "3")
            {
                btn_add.Text = "Update";
                btn_create.Visible = true;
                btn_delete.Visible = true;
            }
            getdetail();
        }

        protected void gdv_Company_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[1].Visible = false; // hides the first column
        }

        protected void ddl_c0mpany_SelectedIndexChanged(object sender, EventArgs e)
        {
            clearfields();
            bindGrid();
        }

        protected void ddl_c0mpany_DataBound(object sender, EventArgs e)
        {
            bindGrid();
        }
    }
}