﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.SqlClient;

namespace VMT
{
    public partial class Company : System.Web.UI.Page
    {
        

        string m_SP_VDM_COMPANY_INS_UPD = Properties.Settings.Default.SP_VDM_COMPANY_INS_UPD;
        string m_SP_SELECT_COMPANY = Properties.Settings.Default.SP_SELECT_COMPANY;
        string m_SP_SELECT_COMPANY_DETAIL = Properties.Settings.Default.SP_SELECT_COMPANY_DETAIL;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Companies";

        protected void Page_Load(object sender, EventArgs e)
        {
           
           

            if (!Page.IsPostBack)
            {

                //checks user role
                // userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

               
                bindGrid();
                btn_create.Visible = false;
                btn_delete.Visible = false;

            }
        }

        protected void btn_add_Click(object sender, EventArgs e)
        {

            if (btn_add.Text == "Add New")
            {
                AddUpdate("INSERT");
            }
            else if (btn_add.Text == "Update")
            {
                AddUpdate("UPDATE");
            }
        }



        private void AddUpdate(string strOperation)
        {
            if (txt_CompanyName.Text.Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Company name could not be blank!')", true);
                txt_CompanyName.Focus();
                return;
            }
            int company_id = 0;
            if (strOperation == "INSERT")
            {
                company_id = 0;
            }
            else
            {
                company_id = Int32.Parse(hdn_keyid.Value);
            }
            
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_COMPANY_NAME", txt_CompanyName.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", company_id));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ADDRESS", txt_CompanyAddr.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_COMPANY_EMAIL", txt_CompanyEmail.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_COMPANY_PHONE", txt_CompanyPhone.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
              //  sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_COMPANY_INS_UPD, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                bindGrid();
                clearfields();
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true); 
   
            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Company name already exists')", true);
            }
            else if (retVal == -3)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Company could not be deleted as it has employees')", true);
            }
          
        }

        private void bindGrid()
        {
            try
            {
                DataAccessUtility.BindGridViewViaProcedure(m_SP_SELECT_COMPANY, gdv_Company);
                gdv_Company.SelectedIndex = -1;
            }
            catch
            {
            }
        }

       
        protected void gdv_Company_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
        {
            GridViewRow row = gdv_Company.Rows[e.NewSelectedIndex];
            hdn_keyid.Value = row.Cells[1].Text;

           // if (hdn_role.Value == "3")
          //  {
                btn_add.Text = "Update";
                btn_create.Visible = true;
                btn_delete.Visible = true;
         //   }
            getdetail();
           
            //if (row.Cells[1].Text == "ANATR")
            //{
            //    e.Cancel = true;
               
            //}
        }

        protected void btn_create_Click(object sender, EventArgs e)
        {
            clearfields();
        }

        void getdetail()
        {
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            try
            {
                OleDbParams.Add(new OleDbParameter("V_COMPANY_ID", hdn_keyid.Value));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SELECT_COMPANY_DETAIL, OleDbParams);


                //bind the fields of contact information
                txt_CompanyName.Text = ds.Tables[0].Rows[0]["COMPANY_NAME"].ToString();
                txt_CompanyAddr.Text = ds.Tables[0].Rows[0]["COMPANY_ADDRESS"].ToString();
                txt_CompanyEmail.Text = ds.Tables[0].Rows[0]["COMPANY_EMAIL"].ToString();
                txt_CompanyPhone.Text = ds.Tables[0].Rows[0]["COMPANY_PHONE"].ToString();
            }
            catch
            {
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }
        void clearfields()
        {
            btn_create.Visible = false;
            btn_delete.Visible = false;
            hdn_keyid.Value = "";
            btn_add.Text = "Add New";
            txt_CompanyName.Text = "";
            txt_CompanyAddr.Text = "";
            txt_CompanyEmail.Text = "";
            txt_CompanyPhone.Text = "";
        }

        protected void btn_reset_Click(object sender, EventArgs e)
        {
            if (hdn_keyid.Value == "")
            {
                clearfields();
            }

            else
            {
                getdetail();
            }
        }

        protected void btn_delete_Click(object sender, EventArgs e)
        {
            AddUpdate("DELETE");
        }

        protected void gdv_Company_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[1].Visible = false; // hides the first column
        }
        bool IsValidEmail(string email)
        {
            try {
                var addr = new System.Net.Mail.MailAddress(email);
                return addr.Address == email;
            }
            catch {
                return false;
            }
        }
        protected void txt_CompanyEmail_TextChanged(object sender, EventArgs e)
        {
            if (txt_CompanyEmail.Text.Trim() != "")
            {

                if (!IsValidEmail(txt_CompanyEmail.Text.Trim()))
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Not a Valid Email Address!')", true);
                    txt_CompanyEmail.Focus();
                }
            }
        }
    }
}