﻿using System;
using System.Collections.Generic;
using System.Web.UI;
using System.Data.OleDb;
using DataAccess;

namespace VMT
{
    public partial class Chemical_SprayBusinessUnit : System.Web.UI.Page
    {
        string m_SP_SPR_BU_CHEMICALS_INS_DEL = Properties.Settings.Default.SP_SPR_BU_CHEMICALS_INS_DEL;
        string m_SP_SPR_BU_CHEMICAL = Properties.Settings.Default.SP_SPR_BU_CHEMICAL;
        string m_SP_SPR_SELECT_BU_NOT_CHEMICAL = Properties.Settings.Default.SP_SPR_SELECT_BU_NOT_CHEMICAL;
        string m_SP_SPR_SELECT_CHEMICAL = Properties.Settings.Default.SP_SPR_SELECT_CHEMICAL;
        string m_SP_SPR_SELECT_UOM_CHEMICAL = Properties.Settings.Default.SP_SPR_SELECT_UOM_CHEMICAL;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Spray Business Unit (Chemical)";

        protected void Page_Load(object sender, EventArgs e)
        {
           

            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
                //if (userRole == "Edit")
                //{
                //    btn_add.Visible = true;
                //    btn_delete.Visible = true;
                //}
                //else
                //{
                //    btn_add.Visible = false;
                //    btn_delete.Visible = false;
                //}

                bindBusinessUnit();
                bindBusinessUnitNotChemicals();
                bindBusinessUnitExistingChemicals();
                bindUOM();
            }
        }
    
    protected void btn_add_Click(object sender, EventArgs e)
        {
            AddUpdate("INSERT");
        }


        private void AddUpdate(string strOperation)
        {
            if (ddl_BUnit.SelectedIndex == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Choose Business Unit!')", true);
                ddl_BUnit.Focus();
                return;
            }
            int CHEMICAL_ID = 0;
            if (strOperation == "DELETE")
            {
                if (lst_BUnitCompany.SelectedIndex == -1)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Choose Chemical to Delete')", true);
                    lst_BUnitCompany.Focus();
                    return;
                }
                else
                {
                    CHEMICAL_ID = Int32.Parse(lst_BUnitCompany.SelectedValue);
                }
            }

            else
            {
                if (ddl_chemical.SelectedIndex == -1)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Choose Chemical!')", true);
                    ddl_chemical.Focus();
                    return;
                }
                else
                {
                    CHEMICAL_ID = Int32.Parse(ddl_chemical.SelectedValue);
                }
            }





            int retVal = 0;
            int UOM_ID = Int32.Parse(ddl_UOM.SelectedValue);
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_BUnit.SelectedValue.ToString()));
                sqlParams.Add(new OleDbParameter("V_CHEMICAL_ID", CHEMICAL_ID));
                sqlParams.Add(new OleDbParameter("V_UOM_ID", UOM_ID));
                sqlParams.Add(new OleDbParameter("V_treatment_type_id",  ddl_treatement_flag.SelectedValue) );
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                //  sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPR_BU_CHEMICALS_INS_DEL, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                bindBusinessUnitNotChemicals();
                bindBusinessUnitExistingChemicals();

                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Chemical already exists')", true);
            }

        }

        int SelectedRetreatmentFlag()
        {
            int v_treatement_flag = 0;
            if (ddl_treatement_flag.SelectedValue == "Y")
                v_treatement_flag = 1;
            else if (ddl_treatement_flag.SelectedValue == "N")
                v_treatement_flag = 0;
            return v_treatement_flag;
        }
        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPR_BU_CHEMICAL, ddl_BUnit);
            }
            catch
            {
            }
        }
        void bindBusinessUnitNotChemicals()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_BUnit.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_TREATMENT_TYPE_ID", ddl_treatement_flag.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_SELECT_BU_NOT_CHEMICAL, OledbParams, ddl_chemical);
            }
            catch
            {
            }
        }
        void bindBusinessUnitExistingChemicals()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_BUnit.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_TREATMENT_TYPE_ID", ddl_treatement_flag.SelectedValue));
                DataAccessUtility.BindListboxWithConditionViaProcedure(m_SP_SPR_SELECT_CHEMICAL, OledbParams, lst_BUnitCompany);
            }
            catch
            {
            }
        }
        void bindUOM()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPR_SELECT_UOM_CHEMICAL, ddl_UOM);
            }
            catch
            {
            }
        }
        protected void ddl_BUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindBusinessUnitNotChemicals();
            bindBusinessUnitExistingChemicals();
        }

        protected void ddl_BUnit_DataBound(object sender, EventArgs e)
        {
            bindBusinessUnitNotChemicals();
            bindBusinessUnitExistingChemicals();
        }

        protected void btn_delete_Click(object sender, EventArgs e)
        {
            AddUpdate("DELETE");
        }

        protected void ddl_treatement_flag_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindBusinessUnitNotChemicals();
            bindBusinessUnitExistingChemicals();
        }
    }
}