﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Data.SqlClient;
using DataAccess;
namespace VMT
{
    public partial class BusinessUnit : System.Web.UI.Page
    {
        string m_SP_SELECT_M_BUSINESS_UNIT = Properties.Settings.Default.SP_SELECT_M_BUSINESS_UNIT;
        string m_SP_SELECT_BUSINESS_UNIT_DETAIL = Properties.Settings.Default.SP_SELECT_BUSINESS_UNIT_DETAIL;
        string m_SP_VDM_BUSINESS_UNIT_INS_UPD = Properties.Settings.Default.SP_VDM_BUSINESS_UNIT_INS_UPD;
        string m_SP_SELECT_BUSINESS_UNIT_TYPE = Properties.Settings.Default.SP_SELECT_BUSINESS_UNIT_TYPE;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Business Unit";

        protected void Page_Load(object sender, EventArgs e)
        {
            
            

            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                hdn_role.Value = userRole;
                

                bindBusinessUnitType();
                BindGrid();
                btn_create.Visible = false;
                btn_delete.Visible = false;

            }

        }
        void bindBusinessUnitType()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SELECT_BUSINESS_UNIT_TYPE, ddl_BUnitType);
            }
            catch
            {
            }
        }
        protected void BindGrid()
        {
            try
            {
                DataAccessUtility.BindGridViewViaProcedure(m_SP_SELECT_M_BUSINESS_UNIT, gdv_BusinessUnit);
                gdv_BusinessUnit.SelectedIndex = -1;
            }
            catch
            {
            }
        }

        protected void btn_add_Click(object sender, EventArgs e)
        {

            if (btn_add.Text == "Add New")
            {
                AddUpdate("INSERT");
            }
            else if (btn_add.Text == "Update")
            {
                AddUpdate("UPDATE");
            }
        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            AddUpdate("UPDATE");
        }

        protected void btn_delete_Click(object sender, EventArgs e)
        {
            AddUpdate("DELETE");
        }

        protected void btn_create_Click(object sender, EventArgs e)
        {
            ClearFields();
        }

        void ClearFields()
        {
            btn_create.Visible = false;
            btn_delete.Visible = false;
            hdn_keyid.Value = "";
            btn_add.Text = "Add New";
            txtBusinessUnit.Text = "";
        }

        protected void btn_reset_Click(object sender, EventArgs e)
        {
            if (hdn_keyid.Value == "")
            {
                ClearFields();
            }

            else
            {
                GetDetail();
            }
        }

        void GetDetail()
        {
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            try
            {
                OleDbParams.Add(new OleDbParameter("BUSINESS_UNIT_ID", hdn_keyid.Value));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SELECT_BUSINESS_UNIT_DETAIL, OleDbParams);
                txtBusinessUnit.Text = ds.Tables[0].Rows[0]["BUSINESS_UNIT"].ToString();
                ddl_retreatflag.SelectedValue = ds.Tables[0].Rows[0]["treatment_type_id"].ToString();
                ddl_BUnitType.SelectedValue = ds.Tables[0].Rows[0]["BUSINESS_UNIT_TYPE"].ToString();
            }
            catch
            {
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }
        protected void gdv_BusinessUnit_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
        {
            GridViewRow row = gdv_BusinessUnit.Rows[e.NewSelectedIndex];
            hdn_keyid.Value = row.Cells[1].Text;

            if (hdn_role.Value == "3")
            {
                btn_add.Text = "Update";
                btn_create.Visible = true;
                btn_delete.Visible = true;
            }
            GetDetail();
        }

        private void AddUpdate(string strOperation)
        {
            if (txtBusinessUnit.Text.Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Business unit could not be blank!')", true);
                txtBusinessUnit.Focus();
                return;
            }

            int businessUnit_id = 0;
            if (strOperation == "INSERT")
            {
                businessUnit_id = 0;
            }
            else
            {
                businessUnit_id = Int32.Parse(hdn_keyid.Value);
            }

            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT", txtBusinessUnit.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_treatment_type_id", ddl_retreatflag.SelectedValue.Trim()));
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", businessUnit_id));
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_TYPE", ddl_BUnitType.SelectedValue.Trim()));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
               // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_BUSINESS_UNIT_INS_UPD, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                BindGrid();
                ClearFields();
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Business unit already exists')", true);
            }


        }

        protected void gdv_BusinessUnit_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[1].Visible = false; // hides the first column
        }

     }
 }
