﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;
using System.IO;

namespace VMT
{
    public partial class AssignmentHistory : System.Web.UI.Page
    {
        string m_SP_SELECT_ASSGN_HISTORY_BU = Properties.Settings.Default.SP_SELECT_ASSGN_HISTORY_BU;       

        string m_SP_SELECT_COMPANY_FOR_EC_HIST= Properties.Settings.Default.SP_SELECT_COMPANY_FOR_EC_HIST;
        string m_SP_SELECT_RATE_YEARS_BU_HIST= Properties.Settings.Default.SP_SELECT_RATE_YEARS_BU_HIST;
        string m_SP_SELECT_EC_RATE_COMP_HIST= Properties.Settings.Default.SP_SELECT_EC_RATE_COMP_HIST;
        string m_SP_VDM_SELECT_RATES_CMP_HIST= Properties.Settings.Default.SP_VDM_SELECT_RATES_CMP_HIST;
        string m_SP_VDM_SELECT_RATE_CMP_WA_HIST = Properties.Settings.Default.SP_VDM_SELECT_RATE_CMP_WA_HIST;
        string m_SP_SELECT_EV_WA_PAYMENT_HIST = Properties.Settings.Default.SP_SELECT_EV_WA_PAYMENT_HIST;

        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Assignment History";

        string BU = "";
        string EC = "";
        string YR = "";

        protected void Page_Load(object sender, EventArgs e)
        {
            

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(btn_expExcel);
            scriptManager.RegisterPostBackControl(btnEXcelRateCmpWA);
            scriptManager.RegisterPostBackControl(btnEXcelPaymentHist);

            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                bindBusinessUnit();
                //if (BU == "")
                //{
                //    //ddl_Bunit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                //    bindYear();
                //}
                //else
                //{
                //    //ddl_Bunit.SelectedValue = BU;
                //    bindYear();
                //}
                //if (YR == "")
                //{
                //    //ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                //    BindEventCode();
                //}
                //else
                //{
                //    //ddl_Year.SelectedValue = YR;
                //    BindEventCode();
                //}
                //if (EC != "")
                //{
                //    ddlEventCode.SelectedValue = EC;
                //    //bindCompany();
                //}
            }
        }

      

        void bindCompany()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR_ID = 0;
            int V_EVENT_CODE_ID = 0;

            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR_ID = Convert.ToInt32(ddl_Year.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", V_YEAR_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_COMPANY_FOR_EC_HIST, OledbParams, ddl_Company);
                gdv_Rate_Company_Wa.DataSource = null;
                gdv_Rate_Company_Wa.DataBind();
                gdv_ev_wa_payment_hist.DataSource = null;
                gdv_ev_wa_payment_hist.DataBind();
            }
            catch
            {
            }
        }
        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SELECT_ASSGN_HISTORY_BU, ddl_Bunit);
                gdv_Rate_Company_Wa.DataSource = null;
                gdv_Rate_Company_Wa.DataBind();
                gdv_ev_wa_payment_hist.DataSource = null;
                gdv_ev_wa_payment_hist.DataBind();
            }
            catch
            {
            }
        }
        void bindYear()
        {
            ddl_Year.Items.Clear();
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_RATE_YEARS_BU_HIST, OledbParams, ddl_Year);
                gdv_Rate_Company_Wa.DataSource = null;
                gdv_Rate_Company_Wa.DataBind();
                gdv_ev_wa_payment_hist.DataSource = null;
                gdv_ev_wa_payment_hist.DataBind();
            }
            catch
            {
            }
        }
        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindYear();   
        }

        protected void ddl_Bunit_DataBound(object sender, EventArgs e)
        {
            bindYear();
            if (!Page.IsPostBack)
            {
                if (YR == "")
                {
                    //ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                }
                else
                {
                    ddl_Year.SelectedValue = YR;
                }
            }
            
          
           
        }

        protected void ddl_Year_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (ddl_Year.Items.Count >0)
                 BindEventCode();
        }

        protected void ddl_Year_DataBound(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                if (YR == "")
                {
                    // ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                }
                else
                {
                    ddl_Year.SelectedValue = YR;
                }
            }

            BindEventCode();
        }

       

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {            
            bindCompany();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindCompany();
        }
        protected void ddl_Company_SelectedIndexChanged(object sender, EventArgs e)
        {          
            bindGrid();

            if (ddl_Company.SelectedIndex == 0)
                bindCompany();
            BindWorkAreaHistGrid();
            BindPaymentHistGrid();
        }

        protected void ddl_Company_DataBound(object sender, EventArgs e)
        {
            bindGrid();
            BindWorkAreaHistGrid();
            BindPaymentHistGrid();
        }

        public int intnull(string inttext)
        {
            int value1 = 0;
            try
            {
                value1 = Convert.ToInt32(inttext);
            }
            catch (Exception ex)
            {          
                value1 = 0;
            }
            return value1;
        }


        void BindEventCode()
        {

            ddlEventCode.Items.Clear();
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_EC_RATE_COMP_HIST, OledbParams, ddlEventCode);
            }
            catch
            {
            }
        }


        private void bindGrid()
        {
            

            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_COMPANY_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_COMPANY_ID = intnull(ddl_Company.SelectedValue);

                V_EVENT_CODE_ID = intnull(ddlEventCode.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_SELECT_RATES_CMP_HIST, OledbParams, gdv_Rate_Company);

                //DataTable dt = new DataTable();
                //gdv_Rate_Company.DataSource = dt;
                //if (gdv_Rate_Company.Rows.Count > 0)
                //{
                //    decimal total = dt.AsEnumerable().Sum(row => row.Field<decimal>("NONBILLABLEMILES"));
                //    gdv_Rate_Company.FooterRow.Cells[3].Text = "Total:";
                //    gdv_Rate_Company.FooterRow.Cells[5].HorizontalAlign = HorizontalAlign.Right;
                //    gdv_Rate_Company.FooterRow.Cells[5].Text = total.ToString();
                //}
            }
            catch
            {
            }

            
            if (gdv_Rate_Company.Rows.Count > 0)
            {
                btn_expExcel.Visible = true;
            }

            else
                btn_expExcel.Visible = false;
            CheckExcelBtnVisibility();
           
        }
        
        protected void btn_expExcel_Click(object sender, EventArgs e)
        {
            try
            {
                gdv_Rate_Company.ShowHeader = true;
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddl_Bunit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddl_Year.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
                dictionaryFilters.Add("Company", ddl_Company.SelectedItem.Text);
                List<int> listColumnIndex = new List<int>(new int[] { 0 });
                VDMUtil.ExportGridToExcel(gdv_Rate_Company, "Rate Company History", "RateCompanyHistory", dictionaryFilters, listColumnIndex);
            }
            catch
            {
            }
        }

        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }

        //protected void LinkButton1_Click(object sender, EventArgs e)
        //{
        //    LinkButton btn = (LinkButton)(sender);
        //    string strRateType = btn.CommandArgument;
        //    BindWorkAreaHistGrid(strRateType);
        //}

        protected void BindWorkAreaHistGrid()
        {
                   
            int V_YEAR = 0;
            int V_COMPANY_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();

                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
               // OledbParams.Add(new OleDbParameter("V_RATE_TYPE_ID", rateType));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_SELECT_RATE_CMP_WA_HIST, OledbParams, gdv_Rate_Company_Wa);
            }
            catch
            {
            }

            CheckExcelBtnVisibility();

            if (gdv_Rate_Company_Wa.Rows.Count > 0)
            {
                btnEXcelRateCmpWA.Visible = true;
            }

            else
                btnEXcelRateCmpWA.Visible = false;

            
        }

        protected void btnEXcelRateCmpWA_Click(object sender, EventArgs e)
        {
            //ExportGridToExcel();
            try
            {
                gdv_Rate_Company_Wa.ShowHeader = true;
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddl_Bunit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddl_Year.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
                dictionaryFilters.Add("Company", ddl_Company.SelectedItem.Text);
                List<int> listColumnIndex = new List<int>(new int[] { });
                VDMUtil.ExportGridToExcel(gdv_Rate_Company_Wa, "Rate Company Workarea History", "RateCompanyWAHistory", dictionaryFilters, listColumnIndex);
            }
            catch
            {
            }
        }

        protected void gdv_Rate_Company_SelectedIndexChanged(object sender, EventArgs e)
        {
            //GridViewRow row = gdv_Rate_Company.SelectedRow;
            //BindWorkAreaHistGrid(Convert.ToInt32(row.Cells[8].Text));
            //BindPaymentHistGrid();
        }

        protected void gdv_Rate_Company_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[8].Visible = false;
        }

        protected void BindPaymentHistGrid()
        {
            

            int V_YEAR = 0;
            int V_COMPANY_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();

                OledbParams.Add(new OleDbParameter("V_cycle_year_id", V_YEAR));          
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SELECT_EV_WA_PAYMENT_HIST, OledbParams, gdv_ev_wa_payment_hist);
            }
            catch
            {
            }

            CheckExcelBtnVisibility();
            if (gdv_ev_wa_payment_hist.Rows.Count > 0)
            {
                btnEXcelPaymentHist.Visible = true;
            }

            else
                btnEXcelPaymentHist.Visible = false;

           
        }

        protected void btnEXcelPaymentHist_Click(object sender, EventArgs e)
        {
           
            try
            {
                gdv_ev_wa_payment_hist.ShowHeader = true;
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddl_Bunit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddl_Year.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
                dictionaryFilters.Add("Company", ddl_Company.SelectedItem.Text);
                List<int> listColumnIndex = new List<int>(new int[] { });
                VDMUtil.ExportGridToExcel(gdv_ev_wa_payment_hist, "Eventcode Workarea Payment History", "EventcodeWAPaymentHistory", dictionaryFilters, listColumnIndex);
            }
            catch
            {
            }
        }

        private void CheckExcelBtnVisibility()
        {
            

            if (ddl_Year.SelectedIndex == 0 || ddlEventCode.SelectedIndex == 0 || ddl_Company.SelectedIndex == 0)
            {
                btn_expExcel.Visible = false;
                btnEXcelPaymentHist.Visible = false;
                btnEXcelRateCmpWA.Visible = false;
            }
           
            

         }

        double stotal = 0.00;
        double nbtotal = 0.00;
        double btotal = 0.00;
        double batotal = 0.00;

        protected void gdv_Rate_Company_RowDataBound(object sender, GridViewRowEventArgs e)
        {


            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //if (gdv_Rate_Company.Rows.Count > 0)
                //{
                    stotal += Convert.ToDouble(DataBinder.Eval(e.Row.DataItem, "SKIPPED_MILES"));
                    nbtotal += Convert.ToDouble(DataBinder.Eval(e.Row.DataItem, "NONBILLABLE_MILES"));
                    btotal += Convert.ToDouble(DataBinder.Eval(e.Row.DataItem, "BILLABLE_MILES"));
                    batotal += Convert.ToDouble(DataBinder.Eval(e.Row.DataItem, "BILLABLE"));
                //}
                
            }

            if (e.Row.RowType == DataControlRowType.Footer)
            {
                e.Row.Cells[3].Text = "Total: ";
                e.Row.Cells[4].Text = string.Format("{0:#.00}", Convert.ToDouble(stotal));
                e.Row.Cells[4].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[5].Text = string.Format("{0:#.00}", Convert.ToDouble(nbtotal));
                e.Row.Cells[5].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[6].Text = string.Format("{0:#.00}", Convert.ToDouble(btotal));
                e.Row.Cells[6].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[7].Text = string.Format("{0:#.00}", Convert.ToDouble(batotal));
                e.Row.Cells[7].HorizontalAlign = HorizontalAlign.Right;
            }
        }
        
        }
}