﻿using DataAccess;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.OleDb;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace VMT
{
    public partial class AddVMSAccrual : System.Web.UI.Page
    {
        string m_SP_VAC_SELECT_EVENT_CODE = Properties.Settings.Default.SP_VAC_SELECT_EVENT_CODE;
        string m_SP_VAC_SEL_WA_FOR_EVCODE = Properties.Settings.Default.SP_VAC_SEL_WA_FOR_EVCODE;
        string m_SP_VAC_SELECT_COMPANY = Properties.Settings.Default.SP_VAC_SELECT_COMPANY;
        string m_SP_VAC_SELECT_YR = Properties.Settings.Default.SP_VAC_SELECT_YR;
        string m_SP_VAC_YR_END_ACCRUAL_INS_DEL = Properties.Settings.Default.SP_VAC_YR_END_ACCRUAL_INS_DEL;
        string m_SP_VAC_SELECT_LAST_ACCRUAL_WA = Properties.Settings.Default.SP_VAC_SELECT_LAST_ACCRUAL_WA;

         int BusinessUnit;
         int EventCode;
         int WorkArea;
         int company;
         int year;
         public static string OperationMode = string.Empty;

        protected void Page_Load(object sender, EventArgs e)
        {
            if(!Page.IsPostBack)
            {
                BusinessUnit = Request.QueryString["bu"] == "" ? 0 : Convert.ToInt32(Request.QueryString["bu"]);
                EventCode = Request.QueryString["ec"] == "" ? 0 : Convert.ToInt32(Request.QueryString["ec"]);
                WorkArea = Request.QueryString["wa"] == "" ? 0 : Convert.ToInt32(Request.QueryString["wa"]);
                company = Request.QueryString["ci"] == "" ? 0 : Convert.ToInt32(Request.QueryString["ci"]);
                year = Request.QueryString["yr"] == "" ? 0 : Convert.ToInt32(Request.QueryString["yr"]);
                OperationMode = Request.QueryString["om"];
                BindCompany();
                BindAccrualYear();
                BindEventCodeAll();
                getdetail();
                if (OperationMode == "A")
                {
                    divhide.Visible = false;
                    rowAmount.Visible = true;
                }
                else
                {
                    divhide.Visible = true;
                    rowAmount.Visible = false;
                }
            }
        }

        void BindEventCodeAll()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = BusinessUnit;
                //V_EVENT_CODE_ID = EventCode;
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VAC_SELECT_EVENT_CODE, OledbParams, ddlEventCode);
                ddlEventCode.SelectedValue = EventCode.ToString();
            }
            catch (Exception ex)
            {
            }
        }
        void BindWorkAreaAll()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", WorkArea));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", EventCode));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VAC_SEL_WA_FOR_EVCODE, OledbParams, ddlWorkArea);
            }
            catch (Exception ex)
            {
            }
        }

        void BindCompany()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VAC_SELECT_COMPANY, ddlCompany);
                ddlCompany.SelectedValue = company.ToString();
            }
            catch
            {
            }

        }

        void BindAccrualYear()
        {
            //string V_OPR_MODE = string.Empty;
            //int V_BUSINESS_UNIT_ID = 0;
            try
            {
                //V_OPR_MODE = OperationMode;
                //V_BUSINESS_UNIT_ID = BusinessUnit;
                //List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                //OledbParams.Add(new OleDbParameter("V_OPR_MODE", V_OPR_MODE));
                //OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                //DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VAC_SELECT_YR, OledbParams, ddlYear);
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VAC_SELECT_YR, ddlYear);
                //ddlYear.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                ddlYear.SelectedValue = year.ToString();
            }
            catch
            {
            }
        }
        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            BindWorkAreaAll();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindWorkAreaAll();
        }

        protected void btn_addRates_Click(object sender, EventArgs e)
        {
            if (OperationMode == "A" && txtAmount.Text.Trim() == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Amount could not be blank.');", true);
                txtAmount.Focus();
                return;
            }

            //string strOperation = "";
            //string V_OPR_MODE = string.Empty;
            //int V_OBJECTID = 0;
            //int V_YEAR_ID = 0;
            //int V_WORK_AREA_ID = 0;
            //int V_COMPANY_ID = 0;
            //double V_ACCRUED_AMOUNT = 0;
            //double V_MILEAGE = 0;

            //double V_BILLABLE = 0;
            //double V_NON_BILLABLE = 0;
            //double V_URBAN_MILE = 0;
            //double V_RURAL_MILE = 0;
            //double V_CLIMBING_MILE = 0;
            //double V_HELICOPTER_MILE = 0;
            //double V_URBAN_AMOUNT = 0;
            //double V_RURAL_AMOUNT = 0;
            //double V_CLIMBING_AMOUNT = 0;
            //double V_HELICOPTER_AMOUNT = 0;
            //  DateTime V_EFFECTIVE_DATE;
            Accrual obj = new Accrual();

            try
            {
                obj.V_OPERATION = "INSERT";
                obj.V_OPR_MODE = OperationMode;
                
                obj.V_YEAR_ID = Convert.ToInt32(ddlYear.SelectedValue);
                obj.V_WORK_AREA_ID = Convert.ToInt32(ddlWorkArea.SelectedValue);
                if (string.IsNullOrEmpty(txtAmount.Text) == false)
                {
                    obj.V_ACCRUED_AMOUNT = Convert.ToDouble(txtAmount.Text);
                }
                else
                {
                    obj.V_ACCRUED_AMOUNT = 0;
                }
                //V_EFFECTIVE_DATE = Convert.ToDateTime(txtEffectiveDate.Text);
                obj.V_COMPANY_ID = Convert.ToInt32(ddlCompany.SelectedValue);
                obj.V_MILEAGE = txtMileage.Text == "" ? 0 : Convert.ToDouble(txtMileage.Text);
                obj.V_BILLABLE = txtBillable.Text == "" ? 0 : Convert.ToDouble(txtBillable.Text.Trim());
                obj.V_NON_BILLABLE = txtNonBillable.Text == "" ? 0 : Convert.ToDouble(txtNonBillable.Text.Trim());
                obj.V_URBAN_MILE = txtUrbanMiles.Text == "" ? 0 : Convert.ToDouble(txtUrbanMiles.Text.Trim());
                obj.V_RURAL_MILE = txtRuralMiles.Text == "" ? 0 : Convert.ToDouble(txtRuralMiles.Text.Trim());
                obj.V_CLIMBING_MILE = txtClimbingMiles.Text == "" ? 0 : Convert.ToDouble(txtClimbingMiles.Text.Trim());
                obj.V_HELICOPTER_MILE = txtHelicopterMiles.Text == "" ? 0 : Convert.ToDouble(txtHelicopterMiles.Text.Trim());
                obj.V_URBAN_AMOUNT = txtUrbanAmount.Text == "" ? 0 : Convert.ToDouble(txtUrbanAmount.Text.Trim());
                obj.V_RURAL_AMOUNT = txtRuralAmount.Text == "" ? 0 : Convert.ToDouble(txtRuralAmount.Text.Trim());
                obj.V_CLIMBING_AMOUNT = txtClimbingAmount.Text == "" ? 0 : Convert.ToDouble(txtClimbingAmount.Text.Trim());
                obj.V_HELICOPTER_AMOUNT = txtHelicopterAmount.Text == "" ? 0 : Convert.ToDouble(txtHelicopterAmount.Text.Trim());
                obj.V_FLAT_AMOUNT = txtFlatAmount.Text == "" ? 0 : Convert.ToDouble(txtFlatAmount.Text.Trim());

                AddDelete(obj);

                //BindEventCode();
                //ddl_EventCode.SelectedValue = ddlEventCode.SelectedValue;
                //BindWorkArea();
                //BindAccrual();

                txtAmount.Text = "";
                txtMileage.Text = "";
                txtFlatAmount.Text = "";
                txtBillable.Text = "";
                txtNonBillable.Text = "";
                txtUrbanMiles.Text = "";
                txtUrbanAmount.Text = "";
                txtRuralMiles.Text = "";
                txtRuralAmount.Text = "";
                txtClimbingMiles.Text = "";
                txtClimbingAmount.Text = "";
                txtHelicopterMiles.Text = "";
                txtHelicopterAmount.Text = "";

                Response.Write("<script>window.close();window.opener.document.getElementById('btn_addRates').click();</script>");
            }
            catch (Exception ex)
            {
            }
        }

        private void AddDelete(Accrual obj)
        {
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", obj.V_OPERATION));
                sqlParams.Add(new OleDbParameter("V_OPR_MODE", obj.V_OPR_MODE));
                sqlParams.Add(new OleDbParameter("V_OBJECTID", obj.V_OBJECTID));
                sqlParams.Add(new OleDbParameter("V_YEAR_ID", obj.V_YEAR_ID));
                sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", obj.V_WORK_AREA_ID));
                sqlParams.Add(new OleDbParameter("V_ACCRUED_AMOUNT", obj.V_ACCRUED_AMOUNT));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", obj.V_COMPANY_ID));
                sqlParams.Add(new OleDbParameter("V_MILEAGE", obj.V_MILEAGE));
                //sqlParams.Add(new OleDbParameter("V_EFFECTIVE_DATE", V_EFFECTIVE_DATE));
                sqlParams.Add(new OleDbParameter("V_BILLABLE", obj.V_BILLABLE));
                sqlParams.Add(new OleDbParameter("V_NON_BILLABLE", obj.V_NON_BILLABLE));
                sqlParams.Add(new OleDbParameter("V_URBAN_MILES", obj.V_URBAN_MILE));
                sqlParams.Add(new OleDbParameter("V_RURAL_MILES", obj.V_RURAL_MILE));
                sqlParams.Add(new OleDbParameter("V_CLIMBING_MILES", obj.V_CLIMBING_MILE));
                sqlParams.Add(new OleDbParameter("V_HELICOPTER_MILES", obj.V_HELICOPTER_MILE));
                sqlParams.Add(new OleDbParameter("V_FLAT_AMT", obj.V_FLAT_AMOUNT));
                sqlParams.Add(new OleDbParameter("V_URBAN_AMT", obj.V_URBAN_AMOUNT));
                sqlParams.Add(new OleDbParameter("V_RURAL_AMT", obj.V_RURAL_AMOUNT));
                sqlParams.Add(new OleDbParameter("V_CLIMBING_AMT", obj.V_CLIMBING_AMOUNT));
                sqlParams.Add(new OleDbParameter("V_HELICOPTER_AMT", obj.V_HELICOPTER_AMOUNT));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VAC_YR_END_ACCRUAL_INS_DEL, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {

                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + obj.V_OPERATION.ToLower() + " successful.')", true);

            }
            else if (retVal == -1)
            {
                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation.ToLower() + " failed.')", true);
            }

        }

        void getdetail()
        {
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            try
            {
                OleDbParams.Add(new OleDbParameter("V_OPR_MODE", OperationMode));
                OleDbParams.Add(new OleDbParameter("V_YEAR_ID", ddlYear.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_WORK_AREA_ID", ddlWorkArea.SelectedValue));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_VAC_SELECT_LAST_ACCRUAL_WA, OleDbParams);


                //bind the fields 
                if (ds.Tables[0].Rows.Count > 0)
                {
                    txtMileage.Text = ds.Tables[0].Rows[0]["MILEAGE"].ToString() == "" ? "0.00" : ds.Tables[0].Rows[0]["MILEAGE"].ToString();
                    txtBillable.Text = ds.Tables[0].Rows[0]["BILLABLE"].ToString() == "" ? "0.00" : ds.Tables[0].Rows[0]["BILLABLE"].ToString();
                    txtNonBillable.Text = ds.Tables[0].Rows[0]["NON_BILLABLE"].ToString() == "" ? "0.00" : ds.Tables[0].Rows[0]["NON_BILLABLE"].ToString();
                    txtFlatAmount.Text = ds.Tables[0].Rows[0]["FLAT_AMT"].ToString() == "" ? "0.00" : ds.Tables[0].Rows[0]["FLAT_AMT"].ToString();
                    txtUrbanMiles.Text = ds.Tables[0].Rows[0]["URBAN_MILES"].ToString() == "" ? "0.00" : ds.Tables[0].Rows[0]["URBAN_MILES"].ToString();
                    txtUrbanAmount.Text = ds.Tables[0].Rows[0]["URBAN_AMT"].ToString() == "" ? "0.00" : ds.Tables[0].Rows[0]["URBAN_AMT"].ToString();
                    txtRuralMiles.Text = ds.Tables[0].Rows[0]["RURAL_MILES"].ToString() == "" ? "0.00" : ds.Tables[0].Rows[0]["RURAL_MILES"].ToString();
                    txtRuralAmount.Text = ds.Tables[0].Rows[0]["RURAL_AMT"].ToString() == "" ? "0.00" : ds.Tables[0].Rows[0]["RURAL_AMT"].ToString();
                    txtClimbingMiles.Text = ds.Tables[0].Rows[0]["CLIMBING_MILES"].ToString() == "" ? "0.00" : ds.Tables[0].Rows[0]["CLIMBING_MILES"].ToString();
                    txtClimbingAmount.Text = ds.Tables[0].Rows[0]["CLIMBING_AMT"].ToString() == "" ? "0.00" : ds.Tables[0].Rows[0]["CLIMBING_AMT"].ToString();
                    txtHelicopterMiles.Text = ds.Tables[0].Rows[0]["HELICOPTER_MILES"].ToString() == "" ? "0.00" : ds.Tables[0].Rows[0]["HELICOPTER_MILES"].ToString();
                    txtHelicopterAmount.Text = ds.Tables[0].Rows[0]["HELICOPTER_AMT"].ToString() == "" ? "0.00" : ds.Tables[0].Rows[0]["HELICOPTER_AMT"].ToString();
                }
                else
                {
                    txtMileage.Text = "";
                    txtBillable.Text = "";
                    txtNonBillable.Text = "";
                    txtFlatAmount.Text = "";
                    txtUrbanMiles.Text = "";
                    txtUrbanAmount.Text = "";
                    txtRuralMiles.Text = "";
                    txtRuralAmount.Text = "";
                    txtClimbingMiles.Text = "";
                    txtClimbingAmount.Text = "";
                    txtHelicopterMiles.Text = "";
                    txtHelicopterAmount.Text = "";
                }
            }
            catch
            {
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }

        protected void ddlWorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            getdetail();
        }

        protected void ddlYear_SelectedIndexChanged(object sender, EventArgs e)
        {
            getdetail();
        }
    }
}